% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{check_aeddo_inputs}
\alias{check_aeddo_inputs}
\title{Check and assert the inputs for the aeddo function.}
\usage{
check_aeddo_inputs(
  data,
  formula,
  k,
  sig_level,
  exclude_past_outbreaks,
  init_theta,
  lower,
  upper,
  method
)
}
\arguments{
\item{data}{A data frame containing the time series data.}

\item{formula}{A model formula for the fixed effects in the hierarchical
model.}

\item{k}{An integer specifying the rolling window size employed for
parameter estimation.}

\item{sig_level}{The quantile from the random effects distribution used for
defining the outbreak detection threshold.}

\item{exclude_past_outbreaks}{Logical indicating whether past
outbreak-related observations should be excluded from future parameter
estimation.}

\item{init_theta}{Initial values for model parameters in optimization.}

\item{lower}{Lower bounds for optimization parameters.}

\item{upper}{Upper bounds for optimization parameters.}

\item{method}{The optimization method to use, either "BFGS" or "L-BFGS-B".}
}
\value{
Returns nothing. Raises errors if the inputs do not meet the
specified criteria.
}
\description{
This function is for internal use and checks the validity of inputs to the
aeddo function. It performs various checks using the checkmate package to
ensure that the inputs conform to expected types and values.
}
\examples{
\dontrun{
# This function is for internal use and is called within the aeddo function.
# It is not intended to be called directly by users.
}
}
\keyword{internal}
