`possibleNumeric` <- function(x, ...) {
    if (all(is.na(x))) {
        return(FALSE)
    }

    other.args <- list(...)

    if (is.element("labelled", names(other.args))) {
        print(1)
        if (other.args$labelled) {
            print(2)
            return(!any(is.na(suppressWarnings(as.numeric(names(attr(x, "labels")))))))
        }
    }

    if (is.numeric(x)) {
        return(TRUE)
    }

    if (is.factor(x)) {
        return(!any(is.na(suppressWarnings(as.numeric(levels(x))))))
    }

    # as.character converts everything (especially factors)
    return(!any(is.na(suppressWarnings(as.numeric(na.omit(x))))))
}
