% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_scale.R
\name{compute_scale}
\alias{compute_scale}
\title{Compute Scale Parameters}
\usage{
compute_scale(
  source,
  source_range = NULL,
  target_range = NULL,
  flip_direction = FALSE,
  min_n = 1
)
}
\arguments{
\item{source}{A vector of values to be scaled

A numeric vector is expected.}

\item{source_range}{The permitted source range

A numeric vector containing two elements is expected, representing the
lower and upper bounds of the permitted source range. Alternatively, if no
argument is specified for \code{source_range} and \code{target_range}, no
transformation will be performed.}

\item{target_range}{The target range

A numeric vector containing two elements is expected, representing the
lower and upper bounds of the target range. Alternatively, if no
argument is specified for \code{source_range} and \code{target_range}, no
transformation will be performed.}

\item{flip_direction}{Flip direction of the scale?

The transformed values will be reversed within the target range, e.g.
within the range 0 to 100, 25 would be reversed to 75.

This argument will be ignored if \code{source_range} and \code{target_range} aren't
specified.

Default: \code{FALSE}

Permitted Values: \code{TRUE}, \code{FALSE}}

\item{min_n}{Minimum number of values for computation

The minimum number of non-missing values in source for the computation to
be carried out. If the number of non-missing values is below \code{min_n},
the result will be set to missing, i.e. \code{NA}.

A positive integer is expected.

Default: 1}
}
\value{
The average of source transformed to the target range or \code{NA} if
source doesn't contain \code{min_n} values.
}
\description{
Computes the average of a set of source values and transforms the result
from the source range to the target range. For example, for calculating the
average of a set of questionnaire response scores and re-coding the average
response to obtain a subscale score.
}
\details{
Returns a numeric value. If source contains less than \code{min_n} values,
the result is set to \code{NA}. If \code{source_range} and \code{target_range} aren't
specified, the mean will be computed without any transformation being
performed.
}
\examples{
compute_scale(
  source = c(1, 4, 3, 5),
  source_range = c(1, 5),
  target_range = c(0, 100),
  flip_direction = TRUE,
  min_n = 3
)

}
\seealso{
BDS-Findings Functions that returns a vector: 
\code{\link{compute_bmi}()},
\code{\link{compute_bsa}()},
\code{\link{compute_egfr}()},
\code{\link{compute_framingham}()},
\code{\link{compute_map}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_qual_imputation_dec}()},
\code{\link{compute_rr}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
