% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_ontrtfl.R
\name{derive_var_ontrtfl}
\alias{derive_var_ontrtfl}
\title{Derive On-Treatment Flag Variable}
\usage{
derive_var_ontrtfl(
  dataset,
  new_var = ONTRTFL,
  start_date,
  end_date = NULL,
  ref_start_date,
  ref_end_date = NULL,
  ref_end_window = 0,
  filter_pre_timepoint = NULL,
  span_period = NULL
)
}
\arguments{
\item{dataset}{Input dataset.

Required columns are \code{start_date}, \code{end_date}, \code{ref_start_date} and
\code{ref_end_date}.}

\item{new_var}{On-treatment flag variable name to be created.

Default is \code{ONTRTFL}.}

\item{start_date}{The start date (e.g. \code{AESDT}) or assessment date (e.g.
\code{ADT}) Required; A date or date-time object column is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{end_date}{The end date of assessment/event (e.g. \code{AENDT}) A date or
date-time object column is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Optional; Default is null. If the used and date value is missing on an
observation, it is assumed the medication is ongoing and \code{ONTRTFL} is set
to \code{"Y"}.}

\item{ref_start_date}{The lower bound of the on-treatment period Required; A
date or date-time object column is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{ref_end_date}{The upper bound of the on-treatment period A date or
date-time object column is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Optional; This can be null and everything after \code{ref_start_date} will be
considered on-treatment. Default is \code{NULL}.}

\item{ref_end_window}{A window to add to the upper bound \code{ref_end_date}
measured in days (e.g. 7 if 7 days should be added to the upper bound)
Optional; default is 0.}

\item{filter_pre_timepoint}{An expression to filter observations as not
on-treatment when \code{date} = \code{ref_start_date}. For example, if observations
where \code{VSTPT = PRE} should not be considered on-treatment when \code{date = ref_start_date}, \code{filter_pre_timepoint} should be used to denote when the
on-treatment flag should be set to null. Optional; default is \code{NULL}.}

\item{span_period}{A \code{"Y"} scalar character. If \code{"Y"}, events that started
prior to the \code{ref_start_date}and are ongoing or end after the
\code{ref_start_date} are flagged as \code{"Y"}. Optional; default is \code{NULL}.}
}
\value{
The input dataset with an additional column named \code{ONTRTFL} with a
value of \code{"Y"} or \code{NA}
}
\description{
Derive on-treatment flag (\code{ONTRTFL}) in an ADaM dataset with a single
assessment date (e.g \code{ADT}) or event start and end dates (e.g.
\code{ASTDT}/\code{AENDT}).
}
\details{
On-Treatment is calculated by determining whether the assessment
date or start/stop dates fall between 2 dates. The following logic is used
to assign on-treatment = \code{"Y"}:
\enumerate{
\item \code{start_date} is missing and \code{ref_start_date}is non-missing
\item No timepoint filter is provided (\code{filter_pre_timepoint}) and both
\code{start_date} and \code{ref_start_date} are non-missing and \code{start_date} =
\code{ref_start_date}
\item A timepoint is provided (\code{filter_pre_timepoint}) and both \code{start_date}
and \code{ref_start_date} are non-missing and \code{start_date = ref_start_date} and
the filter provided in \code{filter_pre_timepoint} is not true.
\item \code{ref_end_date} is not provided and \code{ref_start_date < start_date}
\item \code{ref_end_date} is provided and \code{ref_start_date < start_date} <=
\code{ref_end_date + ref_end_window}.
}

If the \code{end_date} is provided and the \code{end_date} < ref_start_date then the
\code{ONTRTFL} is set to \code{NULL}.This would be applicable to cases where the
\code{start_date} is missing and \code{ONTRTFL} has been assigned as \code{"Y"} above.

If the \code{span_period} is specified as \code{"Y"}, this allows the user to assign
\code{ONTRTFL} as \code{"Y"} to cases where the record started prior to the
\code{ref_start_date} and was ongoing or ended after the \code{ref_start_date}.

Any date imputations needed should be done prior to calling this function.
}
\examples{
library(tibble)
library(dplyr)
library(lubridate, warn.conflict = FALSE)

advs <- tribble(
  ~USUBJID, ~ADT,              ~TRTSDT,           ~TRTEDT,
  "P01",    ymd("2020-02-24"), ymd("2020-01-01"), ymd("2020-03-01"),
  "P02",    ymd("2020-01-01"), ymd("2020-01-01"), ymd("2020-03-01"),
  "P03",    ymd("2019-12-31"), ymd("2020-01-01"), ymd("2020-03-01")
)
derive_var_ontrtfl(
  advs,
  start_date = ADT,
  ref_start_date = TRTSDT,
  ref_end_date = TRTEDT
)

advs <- tribble(
  ~USUBJID, ~ADT,              ~TRTSDT,           ~TRTEDT,
  "P01",    ymd("2020-07-01"), ymd("2020-01-01"), ymd("2020-03-01"),
  "P02",    ymd("2020-04-30"), ymd("2020-01-01"), ymd("2020-03-01"),
  "P03",    ymd("2020-03-15"), ymd("2020-01-01"), ymd("2020-03-01")
)
derive_var_ontrtfl(
  advs,
  start_date = ADT,
  ref_start_date = TRTSDT,
  ref_end_date = TRTEDT,
  ref_end_window = 60
)

advs <- tribble(
  ~USUBJID, ~ADTM,                      ~TRTSDTM,                   ~TRTEDTM,
  "P01",    ymd_hm("2020-01-02T12:00"), ymd_hm("2020-01-01T12:00"), ymd_hm("2020-03-01T12:00"),
  "P02",    ymd("2020-01-01"),          ymd_hm("2020-01-01T12:00"), ymd_hm("2020-03-01T12:00"),
  "P03",    ymd("2019-12-31"),          ymd_hm("2020-01-01T12:00"), ymd_hm("2020-03-01T12:00"),
) \%>\%
  mutate(TPT = c(NA, "PRE", NA))
derive_var_ontrtfl(
  advs,
  start_date = ADTM,
  ref_start_date = TRTSDTM,
  ref_end_date = TRTEDTM,
  filter_pre_timepoint = TPT == "PRE"
)

advs <- tribble(
  ~USUBJID, ~ASTDT,            ~TRTSDT,           ~TRTEDT,           ~AENDT,
  "P01",    ymd("2020-03-15"), ymd("2020-01-01"), ymd("2020-03-01"), ymd("2020-12-01"),
  "P02",    ymd("2019-04-30"), ymd("2020-01-01"), ymd("2020-03-01"), ymd("2020-03-15"),
  "P03",    ymd("2019-04-30"), ymd("2020-01-01"), ymd("2020-03-01"), NA,
)
derive_var_ontrtfl(
  advs,
  start_date = ASTDT,
  end_date = AENDT,
  ref_start_date = TRTSDT,
  ref_end_date = TRTEDT,
  ref_end_window = 60,
  span_period = "Y"
)

advs <- tribble(
  ~USUBJID, ~ASTDT,            ~AP01SDT,          ~AP01EDT,          ~AENDT,
  "P01",    ymd("2020-03-15"), ymd("2020-01-01"), ymd("2020-03-01"), ymd("2020-12-01"),
  "P02",    ymd("2019-04-30"), ymd("2020-01-01"), ymd("2020-03-01"), ymd("2020-03-15"),
  "P03",    ymd("2019-04-30"), ymd("2020-01-01"), ymd("2020-03-01"), NA,
)
derive_var_ontrtfl(
  advs,
  new_var = ONTR01FL,
  start_date = ASTDT,
  end_date = AENDT,
  ref_start_date = AP01SDT,
  ref_end_date = AP01EDT,
  span_period = "Y"
)
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr_dir}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()}
}
\author{
Alice Ehmann, Teckla Akinyi
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
