% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_chg.R
\name{derive_var_chg}
\alias{derive_var_chg}
\title{Derive Change from Baseline}
\usage{
derive_var_chg(dataset)
}
\arguments{
\item{dataset}{The input dataset. Required variables are \code{AVAL} and
\code{BASE}.}
}
\value{
The input dataset with an additional column named \code{CHG}
}
\description{
Derive change from baseline (\code{CHG}) in a BDS dataset
}
\details{
Change from baseline is calculated by subtracting the baseline value
from the analysis value.
}
\examples{
advs <- tibble::tribble(
  ~USUBJID, ~PARAMCD, ~AVAL, ~ABLFL, ~BASE,
  "P01",    "WEIGHT", 80,    "Y",    80,
  "P01",    "WEIGHT", 80.8,  "",     80,
  "P01",    "WEIGHT", 81.4,  "",     80,
  "P02",    "WEIGHT", 75.3,  "Y",    75.3,
  "P02",    "WEIGHT", 76,    "",     75.3
)
derive_var_chg(advs)
}
\seealso{
\code{\link[=derive_var_pchg]{derive_var_pchg()}}
}
\author{
Thomas Neitmann
}
\keyword{bds}
\keyword{derivation}
