% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_exist.R
\name{filter_exist}
\alias{filter_exist}
\title{Returns records that fit into existing by groups in a filtered source dataset}
\usage{
filter_exist(dataset, dataset_add, by_vars, filter_add = NULL)
}
\arguments{
\item{dataset}{Input dataset

The variables specified in the \code{by_vars} parameter are expected in this dataset.}

\item{dataset_add}{Source dataset

The source dataset, which determines the by groups returned in the input dataset,
based on the groups that exist in this dataset after being subset by \code{filter_add}.

The variables specified in the \code{by_vars} and \code{filter_add} parameters are expected
in this dataset.}

\item{by_vars}{Grouping variables

A list of variable names specified within \code{exprs()} is expected.}

\item{filter_add}{Filter for the source dataset

The filter condition which will be used to subset the source dataset.
Alternatively, if no filter condition is supplied, no subsetting of the source
dataset will be performed.

Default: \code{NULL} (i.e. no filtering will be performed)}
}
\value{
The records in the input dataset which are contained within an existing by group in
the filtered source dataset.
}
\description{
Returns all records in the input dataset that belong to by groups that are present
in a source dataset, after the source dataset is optionally filtered. For example,
this could be used to return ADSL records for subjects that experienced a certain
adverse event during the course of the study (as per records in ADAE).
}
\details{
Returns the records in \code{dataset} which match an existing by group in \code{dataset_add},
after being filtered according to \code{filter_add}. If there are no by groups that exist
in both datasets, an empty dataset will be returned.
}
\examples{
# Get demographic information about subjects who have suffered from moderate or
# severe fatigue

library(tibble)

adsl <- tribble(
  ~USUBJID,      ~AGE, ~SEX,
  "01-701-1015", 63,   "F",
  "01-701-1034", 77,   "F",
  "01-701-1115", 84,   "M",
  "01-701-1146", 75,   "F",
  "01-701-1444", 63,   "M"
)

adae <- tribble(
  ~USUBJID,      ~AEDECOD,                    ~AESEV,     ~AESTDTC,
  "01-701-1015", "DIARRHOEA",                 "MODERATE", "2014-01-09",
  "01-701-1034", "FATIGUE",                   "SEVERE",   "2014-11-02",
  "01-701-1034", "APPLICATION SITE PRURITUS", "MODERATE", "2014-08-27",
  "01-701-1115", "FATIGUE",                   "MILD",     "2013-01-14",
  "01-701-1146", "FATIGUE",                   "MODERATE", "2013-06-03"
)

filter_exist(
  dataset = adsl,
  dataset_add = adae,
  by_vars = exprs(USUBJID),
  filter_add = AEDECOD == "FATIGUE" & AESEV \%in\% c("MODERATE", "SEVERE")
)

}
\seealso{
Utilities for Filtering Observations: 
\code{\link{count_vals}()},
\code{\link{filter_extreme}()},
\code{\link{filter_joined}()},
\code{\link{filter_not_exist}()},
\code{\link{filter_relative}()},
\code{\link{max_cond}()},
\code{\link{min_cond}()}
}
\concept{utils_fil}
\keyword{utils_fil}
