% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_last_dose_grp.R
\name{derive_var_last_dose_grp}
\alias{derive_var_last_dose_grp}
\title{Derive Last Dose with User-Defined Groupings}
\usage{
derive_var_last_dose_grp(
  dataset,
  dataset_ex,
  filter_ex = NULL,
  by_vars = exprs(STUDYID, USUBJID),
  dose_id = exprs(),
  dose_date,
  analysis_date,
  single_dose_condition = (EXDOSFRQ == "ONCE"),
  new_var,
  grp_brks,
  grp_lbls,
  include_lowest = TRUE,
  right = TRUE,
  dose_var = EXDOSE,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset}{Input dataset.
The variables specified by the \code{by_vars} and \code{analysis_date} parameters are expected.}

\item{dataset_ex}{Input EX dataset.
The variables specified by the \code{by_vars}, \code{dose_date}, \code{new_vars} parameters,
and source variables from \code{traceability_vars} parameter are expected.}

\item{filter_ex}{Filtering condition applied to EX dataset.
For example, it can be used to filter for valid dose.
Defaults to NULL.}

\item{by_vars}{Variables to join by (created by \code{rlang::exprs}).}

\item{dose_id}{Variables to identify unique dose (created by \code{rlang::exprs}).
Defaults to empty \code{exprs()}.}

\item{dose_date}{The EX dose date variable. A date or date-time object is expected.}

\item{analysis_date}{The analysis date variable. A date or date-time object is expected.}

\item{single_dose_condition}{The condition for checking if \code{dataset_ex} is single dose. An error
is issued if the condition is not true. Defaults to \code{(EXDOSFRQ == "ONCE")}.}

\item{new_var}{The output variable defined by the user.}

\item{grp_brks}{User supplied breaks to apply to groups.
Refer to \code{breaks} parameter in \code{cut()} for details.}

\item{grp_lbls}{User supplied labels to apply to groups.
Refer to \code{labels} parameter in \code{cut()} for details.}

\item{include_lowest}{logical, indicating if a value equal to the lowest
(or highest, for right = FALSE) ‘breaks’ value should be included.
Refer to \code{include.lowest} parameter in \code{cut()} for details.}

\item{right}{Logical, indicating if the intervals should be closed on the right
(and open on the left) or vice versa.
Refer to \code{right} parameter in \code{cut()} for details.}

\item{dose_var}{The source dose amount variable. Defaults to \code{EXDOSE}.}

\item{traceability_vars}{A named list returned by \code{\link[=exprs]{exprs()}} listing the traceability variables,
e.g. \code{exprs(LDOSEDOM = "EX", LDOSESEQ = EXSEQ)}.
The left-hand side (names of the list elements) gives the names of the traceability variables
in the returned dataset.
The right-hand side (values of the list elements) gives the values of the traceability variables
in the returned dataset.
These can be either strings or symbols referring to existing variables.}
}
\value{
Input dataset with additional column \code{new_var}.
}
\description{
Add a variable for user-defined dose grouping of the last dose
to the input dataset.

\strong{Note:} This is a wrapper function for the function \code{derive_vars_last_dose()}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_vars_joined()} instead.
}
\details{
Last dose is the dose with maximum \code{dose_date} that is lower to or equal to the
\code{analysis_date} per \code{by_vars} for each observation in \code{dataset}.
The last dose group is then derived by user-defined grouping, which groups
\code{dose_var} as specified in \code{grp_brks}, and returns \code{grp_lbls} as the values for \code{new_var}.

If dose information is aggregated (i.e. is a dosing frequency other than \code{"ONCE"}
over a period defined by a start and end date) the function
\code{create_single_dose_dataset()} can be used to generate single doses from
aggregate dose information and satisfy \code{single_dose_condition}.
}
\seealso{
\code{\link[=derive_vars_last_dose]{derive_vars_last_dose()}}, \code{\link[=cut]{cut()}}, \code{\link[=create_single_dose_dataset]{create_single_dose_dataset()}}

Other deprecated: 
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()}
}
\concept{deprecated}
\keyword{deprecated}
