% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_advs_params.R
\name{compute_map}
\alias{compute_map}
\title{Compute Mean Arterial Pressure (MAP)}
\usage{
compute_map(diabp, sysbp, hr = NULL)
}
\arguments{
\item{diabp}{Diastolic blood pressure

A numeric vector is expected.}

\item{sysbp}{Systolic blood pressure

A numeric vector is expected.}

\item{hr}{Heart rate

A numeric vector or \code{NULL} is expected.}
}
\value{
A numeric vector of MAP values
}
\description{
Computes mean arterial pressure (MAP) based on diastolic and systolic blood
pressure. Optionally heart rate can be used as well.
}
\details{
\deqn{\frac{2DIABP + SYSBP}{3}}{(2DIABP + SYSBP) / 3}
if it is based on diastolic and systolic blood pressure and
\deqn{DIABP + 0.01 e^{4.14 - \frac{40.74}{HR}} (SYSBP - DIABP)}{
DIABP + 0.01 exp(4.14 - 40.74 / HR) (SYSBP - DIABP)}
if it is based on diastolic, systolic blood pressure, and heart rate.

Usually this computation function can not be used with \verb{\%>\%}.
}
\examples{
# Compute MAP based on diastolic and systolic blood pressure
compute_map(diabp = 51, sysbp = 121)

# Compute MAP based on diastolic and systolic blood pressure and heart rate
compute_map(diabp = 51, sysbp = 121, hr = 59)
}
\seealso{
BDS-Findings Functions that returns a vector: 
\code{\link{compute_bmi}()},
\code{\link{compute_bsa}()},
\code{\link{compute_egfr}()},
\code{\link{compute_framingham}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation_dec}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_rr}()},
\code{\link{compute_scale}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
