% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_vars_merged_dtm}
\alias{derive_vars_merged_dtm}
\title{Merge a (Imputed) Datetime Variable}
\usage{
derive_vars_merged_dtm(
  dataset,
  dataset_add,
  by_vars,
  order = NULL,
  new_vars_prefix,
  filter_add = NULL,
  mode = NULL,
  dtc,
  date_imputation = NULL,
  time_imputation = "00:00:00",
  flag_imputation = "auto",
  min_dates = NULL,
  max_dates = NULL,
  preserve = FALSE,
  check_type = "warning",
  duplicate_msg = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{dtc}, and the \code{order}
argument are expected.}

\item{by_vars}{Grouping variables

The input dataset and the selected observations from the additional dataset
are merged by the specified by variables. The by variables must be a unique
key of the selected observations. Variables from the additional dataset can
be renamed by naming the element, i.e., \verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}, similar to
the dplyr joins.

\emph{Permitted Values}: list of variables created by \code{exprs()}}

\item{order}{Sort order

If the argument is set to a non-null value, for each by group the first or
last observation from the additional dataset is selected with respect to
the specified order. The imputed datetime variable can be specified as well
(see examples below).

\emph{Default}: \code{NULL}

\emph{Permitted Values}: list of variables or \verb{desc(<variable>)} function calls
created by \code{exprs()}, e.g., \verb{exprs(ADT, desc(AVAL)} or \code{NULL}}

\item{new_vars_prefix}{Prefix used for the output variable(s).

A character scalar is expected. For the date variable "DT" is appended to
the specified prefix, for the date imputation flag "DTF", and for the time
imputation flag "TMF". I.e., for \code{new_vars_prefix = "AST"} the variables
\code{ASTDT}, \code{ASTDTF}, and \code{ASTTMF} are created.}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations fulfilling the specified condition are taken into account
for merging. If the argument is not specified, all observations are
considered.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: a condition}

\item{mode}{Selection mode

Determines if the first or last observation is selected. If the \code{order}
argument is specified, \code{mode} must be non-null.

If the \code{order} argument is not specified, the \code{mode} argument is ignored.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: \code{"first"}, \code{"last"}, \code{NULL}}

\item{dtc}{The \code{'--DTC'} date to impute

A character date is expected in a format like \code{yyyy-mm-dd} or
\code{yyyy-mm-ddThh:mm:ss}. Trailing components can be omitted and \code{-} is a
valid "missing" value for any component.}

\item{date_imputation}{The value to impute the day/month when a datepart is
missing.

A character value is expected, either as a
\itemize{
\item format with month and day specified as \code{"mm-dd"}: e.g. \code{"06-15"} for the
15th of June (The year can not be specified; for imputing the year
\code{"first"} or \code{"last"} together with \code{min_dates} or \code{max_dates} argument can
be used (see examples).),
\item or as a keyword: \code{"first"}, \code{"mid"}, \code{"last"} to impute to the first/mid/last
day/month.
}

The argument is ignored if \code{highest_imputation} is less then \code{"D"}.

\emph{Default}: \code{"first"}.}

\item{time_imputation}{The value to impute the time when a timepart is
missing.

A character value is expected, either as a
\itemize{
\item format with hour, min and sec specified as \code{"hh:mm:ss"}: e.g. \code{"00:00:00"}
for the start of the day,
\item or as a keyword: \code{"first"},\code{"last"} to impute to the start/end of a day.
}

The argument is ignored if \code{highest_imputation = "n"}.

\emph{Default}: \code{"first"}.}

\item{flag_imputation}{Whether the date/time imputation flag(s) must also be derived.

If \code{"auto"} is specified, the date imputation flag is derived if the
\code{date_imputation} argument is not null and the time imputation flag is
derived if the \code{time_imputation} argument is not null

\emph{Default}: \code{"auto"}

\emph{Permitted Values}: \code{"auto"}, \code{"date"}, \code{"time"}, \code{"both"}, or \code{"none"}}

\item{min_dates}{Minimum dates

A list of dates is expected. It is ensured that the imputed date is not
before any of the specified dates, e.g., that the imputed adverse event start
date is not before the first treatment date. Only dates which are in the
range of possible dates of the \code{dtc} value are considered. The possible dates
are defined by the missing parts of the \code{dtc} date (see example below). This
ensures that the non-missing parts of the \code{dtc} date are not changed.
A date or date-time object is expected.
For example

\if{html}{\out{<div class="sourceCode r">}}\preformatted{impute_dtc_dtm(
  "2020-11",
  min_dates = list(
   ymd_hms("2020-12-06T12:12:12"),
   ymd_hms("2020-11-11T11:11:11")
  ),
  highest_imputation = "M"
)
}\if{html}{\out{</div>}}

returns \code{"2020-11-11T11:11:11"} because the possible dates for \code{"2020-11"}
range from \code{"2020-11-01T00:00:00"} to \code{"2020-11-30T23:59:59"}. Therefore
\code{"2020-12-06T12:12:12"} is ignored. Returning \code{"2020-12-06T12:12:12"} would
have changed the month although it is not missing (in the \code{dtc} date).

For date variables (not datetime) in the list the time is imputed to
\code{"00:00:00"}. Specifying date variables makes sense only if the date is
imputed. If only time is imputed, date variables do not affect the result.}

\item{max_dates}{Maximum dates

A list of dates is expected. It is ensured that the imputed date is not after
any of the specified dates, e.g., that the imputed date is not after the data
cut off date. Only dates which are in the range of possible dates are
considered. A date or date-time object is expected.

For date variables (not datetime) in the list the time is imputed to
\code{"23:59:59"}. Specifying date variables makes sense only if the date is
imputed. If only time is imputed, date variables do not affect the result.}

\item{preserve}{Preserve day if month is missing and day is present

For example \code{"2019---07"} would return \verb{"2019-06-07} if \code{preserve = TRUE}
(and \code{date_imputation = "mid"}).

Permitted Values: \code{TRUE}, \code{FALSE}

\emph{Default}: \code{FALSE}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the (restricted) additional dataset are not unique
with respect to the by variables and the order.

\emph{Default}: \code{"warning"}

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}

\item{duplicate_msg}{Message of unique check

If the uniqueness check fails, the specified message is displayed.

\emph{Default}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{paste("Dataset `dataset_add` contains duplicate records with respect to",
      enumerate(vars2chr(by_vars)))
}\if{html}{\out{</div>}}}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variable \verb{<new_vars_prefix>DT} and
optionally the variables \verb{<new_vars_prefix>DTF} and \verb{<new_vars_prefix>TMF}
derived from the additional dataset (\code{dataset_add}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_vars_dtm()} and
\code{derive_vars_merged()} instead.

Merge a imputed datetime variable, date imputation  flag, and time imputation
flag from a dataset to the input dataset. The observations to merge can be
selected by a condition and/or selecting the first or last observation for
each by group.
}
\details{
\enumerate{
\item The additional dataset is restricted to the observations matching the
\code{filter_add} condition.
\item The datetime variable and if requested, the date imputation flag and
time imputation flag is added to the additional dataset.
\item If \code{order} is specified, for each by group the first or last observation
(depending on \code{mode}) is selected.
\item The date and flag variables are merged to the input dataset.
}
}
\seealso{
Other deprecated: 
\code{\link{derive_derived_param}()},
\code{\link{derive_param_first_event}()},
\code{\link{derive_var_agegr_fda}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_merged_dt}()},
\code{\link{filter_confirmation}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()},
\code{\link{vars}()}
}
\concept{deprecated}
\keyword{deprecated}
