% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hicClust.R
\name{hicClust}
\alias{hicClust}
\title{Adjacency-constrained Clustering of Hi-C contact maps}
\usage{
hicClust(x, h = NULL, ...)
}
\arguments{
\item{x}{either: 1. A pxp contact map of class Matrix::dsCMatrix in which the
entries are the number of counts of physical interactions observed between 
all pairs of loci 2. An object of class HiTC::HTCexp. The corresponding 
Hi-C data is stored as a Matrix::dsCMatrix object in the intdata slot 3. A 
text file with one line per pair of loci for which an interaction has been 
observed (in the format: locus1<tab>locus2<tab>signal).}

\item{h}{band width. If not provided, \code{h} is set to default value `p-1`.}

\item{\dots}{further arguments to be passed to \code{\link{read.table}} 
function when \code{x} is a text file name. If not provided, the text file 
is supposed to be separated by tabulations, with no header.}
}
\value{
An object of class \code{\link{chac}}.
}
\description{
Adjacency-constrained hierarchical agglomerative clustering of Hi-C contact
maps
}
\details{
Adjacency-constrained hierarchical agglomerative clustering (HAC) is HAC in
which each observation is associated to a position, and the clustering is 
constrained so as only adjacent clusters are merged. Genomic regions (loci)
are clustered according to information provided by high-throughput
conformation capture data (Hi-C).
}
\examples{
# input as HiTC::HTCexp object
data("hic_imr90_40_XX", package="adjclust")

# input as HiTC::HTCexp object
res1 <- hicClust(hic_imr90_40_XX)

\dontrun{
# input as Matrix::dsCMatrix contact map
mat <- HiTC::intdata(hic_imr90_40_XX) 
res2 <- hicClust(mat)
} 

# input as text file
res3 <- hicClust(system.file("extdata", "sample.txt", package = "adjclust"))

}
\references{
Dehman A. (2015) \emph{Spatial Clustering of Linkage 
  Disequilibrium Blocks for Genome-Wide Association Studies}, PhD thesis, 
  Universite Paris Saclay.

Servant N. \emph{et al} (2012). \emph{HiTC : Exploration of 
  High-Throughput 'C' experiments. Bioinformatics}.
}
\seealso{
\code{\link{adjClust}} \code{\link[HiTC:HTCexp]{HTCexp}}
}
