% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{current.adf.dir}
\alias{current.adf.dir}
\alias{current.adf.dir,amigaDisk-method}
\alias{current.adf.dir<-}
\alias{current.adf.dir<-,amigaDisk,character-method}
\title{Get or set the current directory of an amigaDisk object}
\usage{
\S4method{current.adf.dir}{amigaDisk}(x)

\S4method{current.adf.dir}{amigaDisk,character}(x) <- value
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object for which the current
directory needs to be obtained or changed.}

\item{value}{A \code{character} representation of the path, that
needs to be set as current directory. Use Amiga DOS syntax as
specified in the details}
}
\value{
Returns a \code{character} representation of the current
directory.
}
\description{
Get or set the current directory of an \code{\link{amigaDisk}} object.
}
\details{
By default the disk's root is stored as the current directory
for a new \code{\link{amigaDisk}} object. With this method, the
current directory can be retrieved or changed.

For this purpose the path should be specified conform Amiga DOS
syntax. Use the disk's name or "DF0" followed by a colon in order
to refer to the disk's root. Subdirectories are separated by forward
slashes ("/"). Colons and forward slashes are not allowed in file and
directory names. Both upper and lowercase letters are allowed in file
and directory names. The case is ignored when identifying files however.
This packages will NOT follow the Amiga's full search path
(\url{http://wiki.amigaos.net/wiki/AmigaOS_Manual:_AmigaDOS_Working_With_AmigaDOS#Search_Path}).
}
\examples{
data(adf.example)

## by default the current dir is the
## disk's root. The disk name is
## therefore shown when running
## current.adf.dir for the provided
## example data:

current.adf.dir(adf.example)

## change the current dir:
current.adf.dir(adf.example) <- "DF0:this/is/a/deep/path"

## confirm that it has changed:
current.adf.dir(adf.example)

## let's set it back to the disk's root:
current.adf.dir(adf.example) <- "DF0:"
}
\author{
Pepijn de Vries
}
