% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_example_statistics}
\alias{get_example_statistics}
\title{Generate a list of estimators and p-values to use in examples}
\usage{
get_example_statistics(
  point_estimators = TRUE,
  interval_estimators = TRUE,
  p_values = TRUE
)
}
\arguments{
\item{point_estimators}{logical indicating whether point estimators should be included in output list}

\item{interval_estimators}{logical indicating whether interval estimators should be included in output list}

\item{p_values}{logical indicating whether p-values should be included in output list}
}
\value{
a list of \code{\link{PointEstimator}}s, \code{\link{IntervalEstimator}}s and
\code{\link{PValue}}.
}
\description{
This function generates a list of objects of class \code{\link{PointEstimator}},
\code{\link{IntervalEstimator}}s, and \code{\link{PValue}}s to use in
examples of the \code{\link{analyze}} function.
}
\details{
\subsection{Point estimators}{

The following \code{\link{PointEstimator}}s are included:
\itemize{
\item \code{\link{SampleMean}}
\item \code{\link{PseudoRaoBlackwell}}
\item \code{\link{MedianUnbiasedLikelihoodRatioOrdering}}
\item \code{\link{BiasReduced}}
}
}

\subsection{Confidence intervals}{

The following \code{\link{IntervalEstimator}}s are included:
\itemize{
\item \code{\link{StagewiseCombinationFunctionOrderingCI}}
\item \code{\link{LikelihoodRatioOrderingCI}}
}
}

\subsection{P-Values}{

The following \code{\link{PValue}}s are included:
\itemize{
\item \code{\link{StagewiseCombinationFunctionOrderingPValue}}
\item \code{\link{LikelihoodRatioOrderingPValue}}
}
}
}
\examples{
set.seed(123)
dat <- data.frame(
  endpoint = c(rnorm(28, 0.3)),
  stage = rep(1, 28)
)
analyze(data = dat,
        statistics = list(),
        data_distribution = Normal(FALSE),
        design = get_example_design(),
        sigma = 1)

# The results suggest recruiting 32 patients for the second stage
dat <- rbind(
  dat,
  data.frame(
    endpoint = rnorm(32, mean = 0.3),
    stage = rep(2, 32)))
analyze(data = dat,
        statistics = get_example_statistics(),
        data_distribution = Normal(FALSE),
        design = get_example_design(),
        sigma = 1)
}
