% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msr.4thcorner.R
\name{msr.4thcorner}
\alias{msr.4thcorner}
\title{Moran spectral randomization for fourth-corner analysis}
\usage{
\method{msr}{4thcorner}(x, listwORorthobasis, phyloORorthobasis,
  nrepet = x$npermut, method = c("pair", "triplet", "singleton"), ...)
}
\arguments{
\item{x}{An object generated by the \code{fourthcorner} function.}

\item{listwORorthobasis}{an object of the class \code{listw} (spatial 
weights) created by the functions of the \pkg{spdep} package or an object 
of class \code{orthobasis}}

\item{phyloORorthobasis}{an object of the class \code{phylo} (phylogeny)
created by the functions of the \pkg{ape} package or an object of class
\code{orthobasis} generated by functions of \pkg{adephylo}
(\code{me.phylo})}

\item{nrepet}{an \code{integer} indicating the number of replicates}

\item{method}{an character specifying which algorithm should be used to 
produce spatial replicates (see code{\link{msr.default}}).}

\item{\dots}{further arguments of the code{\link{msr.default}} function.}
}
\value{
An object of class \code{4thcorner} randomized replicates.
}
\description{
This function allows to test fourth-corner statistics using constrained null
models (for traits and/or environmental variables). If the argument
\code{phyloORorthobasis} is specified, random traits are
phylogenetically-constrained to preserve the global autocorrelation (Moran's
I) and the phylogenetic structures at multiple scales. If not, standard
permutations are used. If the argument \code{listwORorthobasis} is specified,
random environmental variables are spatially-constrained to preserve the
global autocorrelation (Moran's I) and the spatial structures at multiple
scales. If not, standard permutations are used. Multiscale property is
defined by the power spectrum (i.e. decomposition of the variance of the
original variables) on a basis of orthonormal eigenvectors (Moran's
Eigenvector Maps, MEM).
}
\examples{

if(require("ade4", quietly = TRUE) & require("adephylo", quietly = TRUE) 
& require("spdep", quietly = TRUE) & require("ape", quietly = TRUE)){
data(mafragh, package = "ade4")
fr1 <- fourthcorner(mafragh$env, mafragh$flo, mafragh$traits$tabQuantitative, nrepet = 49)
phy <- read.tree(text = mafragh$tre)
lw <- nb2listw(mafragh$nb)
fr1.msr <- msr(fr1, listwORorthobasis = lw, phyloORorthobasis = phy)

fr1
fr1.msr
}

}
\references{
Braga, J., Thuiller, W., ter Braak, C.J.F. and Dray, S.
  (submitted) A novel approach to consider phylogenetic and spatial
  autocorrelations when testing for trait-environment relationships.
}
\seealso{
\code{\link{msr.default}}, \code{\link[adephylo]{me.phylo}}
}
\author{
Stephane Dray \email{stephane.dray@univ-lyon1.fr}
}
\keyword{spatial}
