% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.adass}
\alias{plot.adass}
\title{Plot the results of  the AdaSS method}
\usage{
\method{plot}{adass}(x, ...)
}
\arguments{
\item{x}{The output of   \code{adass.fr}.}

\item{...}{No additional parameters, called for side effects.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides plots of the AdaSS coefficient function estimate when applied to the output of \code{adass.fr}.
}
\examples{
library(adass)
data<-simulate_data("Scenario HAT",n_obs=100)
X_fd=data$X_fd
Y_fd=data$Y_fd
basis_s <- fda::create.bspline.basis(c(0,1),nbasis = 10,norder = 4)
basis_t <- fda::create.bspline.basis(c(0,1),nbasis = 10,norder = 4)
mod_adass <- adass.fr(Y_fd,X_fd,basis_s = basis_s, basis_t = basis_t,
 tun_par=c(10^-6,10^-6,0,0,0,0))
plot(mod_adass)
}
