% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_cap.R
\name{Read.cap}
\alias{Read.cap}
\title{Lower level function that reads data and capture the file information within dependency object}
\usage{
Read.cap(file.info, read.fcn, source_info, ...)
}
\arguments{
\item{file.info}{file information list}

\item{read.fcn}{function for reading the file}

\item{source_info}{source information list}

\item{...}{arguments passed to read.fcn}
}
\value{
object read from files
}
\description{
Lower level function that reads data and capture the file information within dependency object
}
\examples{
\dontrun{
source_info <- create_source_file_dir("adaprHome","tree_controller.R")
testfile <- file.path(source_info$data.dir,"test.csv")
write.csv(cars,testfile)
fileinfo <- createFileInfo(dirname(testfile),basename(testfile),"cars dataset")
Read.cap(fileinfo,read.csv,source_info)
file.remove(file.path(source_info$data.dir,"test.csv"))

} 
}
