% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFunctions.R
\name{hierCredGLM-class}
\alias{hierCredGLM-class}
\alias{print.hierCredGLM}
\alias{summary.hierCredGLM}
\alias{fitted.hierCredGLM}
\title{Class "hierCredGLM" of fitted random effects models estimated with Ohlsson's GLMC algorithm}
\usage{
\method{print}{hierCredGLM}(x, ...)

\method{summary}{hierCredGLM}(object, ...)

\method{fitted}{hierCredGLM}(object, ...)
}
\arguments{
\item{x}{an object of class \code{\link{hierCredGLM}}}

\item{...}{currently ignored.}

\item{object}{an object of class \code{\link{hierCredGLM}}}
}
\value{
The function \code{\link{hierCredGLM}} returns an object of class \code{hierCredGLM}, which has the following slots:

\item{call}{the matched call}

\item{HierarchicalResults}{results of the hierarchical credibility model.}

\item{fitGLM}{the results from fitting the GLM part.}

\item{iter}{total number of iterations.}

\item{Converged}{logical indicating whether the algorithm converged.}

\item{LevelsCov}{object that summarizes the unique levels of each of the contract-specific covariates.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}

\item{prior.weights}{the weights (exposure) initially supplied.}

\item{y}{if requested, the response vector. Default is \code{TRUE}.}
}
\description{
Class "hierCredGLM" of fitted random effects models estimated with Ohlsson's GLMC algorithm
}
\section{{S3 methods}}{

\describe{
 \item{\code{print}:}{Prints the \code{call}, the estimated variance parameters, the unique number of categories
  of the hierarchical MLF and the output of the GLM part. The \code{...} argument is currently ignored. Returns an
  invisible copy of the original object.}
 \item{\code{summary}:}{In addition to the output of the \code{print.hierCredGLM} function, the \code{summary} function
  also prints the random effect estimates and a summary of the GLM (see \code{\link{summary.speedglm}}). Returns an
  invisible copy of the original object.}
  \item{\code{fitted}:}{Returns the fitted values.}
}
}

\seealso{
\code{\link{hierCredGLM}}
}
