% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{plot.actmod}
\alias{plot.actmod}
\title{Plot activity distribution}
\usage{
\method{plot}{actmod}(
  x,
  xunit = c("clock", "hours", "radians"),
  yunit = c("frequency", "density"),
  data = c("histogram", "rug", "both", "none"),
  centre = c("day", "night"),
  dline = list(lwd = ifelse(data == "rug", 0.1, 1)),
  tline = NULL,
  cline = list(lty = 2),
  add = FALSE,
  xaxis = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{actmod}.}

\item{xunit}{Character string defining x-axis unit.}

\item{yunit}{Character string defining y-axis unit.}

\item{data}{Character string defining whether to plot the data distribution and if so which style to use.}

\item{centre}{Character string defining whether to centre the plot on midday or midnight.}

\item{dline}{List of plotting parameters for data lines.}

\item{tline}{List of plotting parameters for trend line.}

\item{cline}{List of plotting parameters for trend confidence interval lines.}

\item{add}{Logical defining whether to create a new plot (default) or add to an existing plot.}

\item{xaxis}{List of plotting parameters to pass to axis command for x-axis plot (see axis for arguments).}

\item{...}{Additional arguments passed to internal plot call affecting only the plot frame and y axis. Modify x axis through xaxis.}
}
\value{
No return value, called to create a plot visualising an activity model.
}
\description{
Plot an activity probability distribution from a fitted \code{actmod} object.
}
\details{
When xunit=="clock", The underlying numeric range of the x-axis is [0,24] if centre=="day",
or [-12,12] if centre=="night".
}
\examples{
data(BCItime)
otm <- 2*pi*subset(BCItime, species=="ocelot")$time
btm <- 2*pi*subset(BCItime, species=="brocket")$time
omod <- fitact(otm)
bmod <- fitact(btm)
plot(omod, yunit="density", data="none")
plot(bmod, yunit="density", data="none", add=TRUE, tline=list(col="red"))
legend("topleft", c("Ocelot", "Brocket deer"), col=1:2, lty=1)

mod <- fitact(otm, sample="data", reps=10)
plot(mod, dline=list(col="grey"),
          tline=list(col="red", lwd=2),
          cline=list(col="red", lty=3))

mod2 <- fitact(otm, bounds=c(pi*3/2, pi/2))
plot(mod2, centre="night")
plot(mod2, centre="night", xlim=c(-6,6), xaxis=list(at=seq(-6,6,2)))
}
