% Generated by roxygen2 (4.0.2): do not edit by hand
\name{compareTimes}
\alias{compareTimes}
\title{Compare activity across between times of day}
\usage{
compareTimes(fit, times)
}
\arguments{
\item{fit}{Fitted \code{actmod} object with errors boostrapped (fit using \code{fitact} with \code{sample} argument != "none").}

\item{times}{Numeric vector of radian times of day at which to compare activity levels. All pairwise comparisons are made.}
}
\value{
A matrix with 4 columns: 1. differences between PDF values; 2. SEs of the differences; 3. Wald statistics; 4. p-values (H0 is no difference between estimates). Matrix rows give all possible pairwise comparisons, numbered in the order in which they appear in vector \code{times}.
}
\description{
Uses a Wald test to statistically compare activity levels at given radian times of day for a fitted activity distribution.
}
\details{
Bootrapping the activity model yields standard error estimates for the PDF. This function uses these SEs to compute a Wald statistic for the difference between PDF values (by inference activity levels) at given times of day: statistic W = (a1-a2)^2 / (SE1^2+SE2^2) tested on chi-sq distribution with 1 degree of freedom.
}
\examples{
data(BCItime)
tPaca <- 2*pi*BCItime$time[BCItime$species=="paca"]
fPaca <- fitact(tPaca, reps=10)
plot(fPaca, hrs=FALSE, frq=FALSE)
compareTimes(fPaca, c(5.5,6,0.5,1))
}

