% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkJumpDistance}
\alias{checkJumpDistance}
\title{Check if fish are jumping over arrays}
\usage{
checkJumpDistance(
  movements,
  fish,
  release,
  dotmat,
  jump.warning,
  jump.error,
  GUI
)
}
\arguments{
\item{movements}{The movements table}

\item{fish}{The fish being analysed}

\item{release}{The release location of the fish}

\item{dotmat}{The matrix of distances between arrays}

\item{jump.warning}{If a fish crosses a number of arrays equal or greater
than \code{jump.error} without being detected, a warning is issued. If left
NULL (default), no warnings are issued.}

\item{jump.error}{If a fish crosses a number of arrays equal or greater than
\code{jump.error} without being detected, user intervention is suggested.
If left NULL (default), user intervention is never suggested.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only if the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open and examine that file. Defaults to "needed".}
}
\value{
A list of movements with updated 'Valid' columns
}
\description{
Check if fish are jumping over arrays
}
\keyword{internal}
