% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_textgrid.R
\name{import_textgrid}
\alias{import_textgrid}
\title{Import a single 'Praat' .TextGrid file}
\usage{
import_textgrid(filePath = NULL, fileContent = NULL, transcriptName = NULL)
}
\arguments{
\item{filePath}{Character string; input path of a single 'Praat' .TextGrid file.}

\item{fileContent}{Vector of character strings; contents of a 'Praat' .TextGrid file read with \code{readLines()}.}

\item{transcriptName}{Character string; name of the transcript.}
}
\value{
Transcript object.
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_new}, \code{act::corpus_import} for importing annotation files.
}
\details{
Imports the contents of a 'Praat' .TextGrid file and returns a transcript object.
The source is either the path to a .TextGrid file or the contents of a .TextGrid file obtained from the \code{@file.content} of an existing transcript object by \code{readLines()}.
If you pass 'fileContent' you need to pass 'transcriptName' as parameter, too.

Please note:
- Time values of annotations in TextGrids may be below 0 seconds. Negative time values will be recognized corretly in the first place. When exporting transcript object to other formats like 'ELAN' .eaf, 'EXMARaLDA' .exb ect. annotations that are completely before 0 sec will be deleted, annotations that start before but end after 0 sec will be truncated. Please see also the function \code{act::transcripts_cure_single}.  
- TextGrids and contained tiers may start and end at different times. These times do not need to match each other. The act package does not support start and end times of TextGrids and tiers and will. The default start of a TextGrid will be 0 seconds or the lowest value in case that annotations start below 0 seconds.
}
\examples{
library(act)

# Path to the .TextGrid file that you want to read
path <- system.file("extdata", "examplecorpus", "GAT", 
					"ARG_I_PAR_Beto.TextGrid", package="act")

# To import a .TextGrid file of your choice:
\dontrun{
path <- "PATH_TO_AN_EXISTING_TEXTGRID_ON_YOUR_COMPUTER"
}


t <- act::import_textgrid(filePath=path)
t


# Content of a .TextGrid (already read by \code{readLines}), 
# e.g. from an existing transcript object:
mycontent <- examplecorpus@transcripts[[1]]@file.content
t <- act::import_textgrid(fileContent=mycontent, transcriptName="test")
t

}
\seealso{
\code{corpus_import}, \code{corpus_new}, \code{import}, \code{import_eaf}, \code{import_exb}, \code{import_rpraat}
}
