% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_exb.R
\name{import_exb}
\alias{import_exb}
\title{Import a single 'EXMARaLDA' .exb file}
\usage{
import_exb(filePath = NULL, fileContent = NULL, transcriptName = NULL)
}
\arguments{
\item{filePath}{Character string; input path of a single 'EXMARaLDA' .exb file.}

\item{fileContent}{Vector of character strings; contents of a 'EXMARaLDA' .exb file .}

\item{transcriptName}{Character string; name of the transcript.}
}
\value{
Transcript object.
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_new}, \code{act::corpus_import} for importing annotation files.
}
\details{
Imports the contents of a 'EXMARaLDA' .exb file and returns a transcript object.
The source is either the path to a .exb file or the contents of a .exb file obtained from the \code{@file.content} of an existing transcript object.
If you pass 'fileContent' you need to pass 'transcriptName' as parameter, too.

Please note: 
- 'EXMARaLDA' allows for empty time slots without a time values. Missing values will be interpolated during the import. You will not be able to recognize interpolated values in the data.  
- Meta data for tiers (such as the display name etc.) will not be imported.
- Media files are referenced not by their path but only as file names in .exb files. The names will be imported but will not work as paths in act.
}
\examples{
library(act)

\dontrun{
	# To import a .TextGrid file of your choice:
	filePath <- "PATH_TO_AN_EXISTING_TEXTGRID_ON_YOUR_COMPUTER"
	
	t <- act::import_exb(filePath=filePath)
	t
}



}
\seealso{
\code{corpus_import}, \code{corpus_new}, \code{import}, \code{import_eaf}, \code{import_rpraat}, \code{import_textgrid}
}
