% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_point_cloud.R
\name{clean_point_cloud}
\alias{clean_point_cloud}
\alias{clean_point_cloud,aRchi-method}
\title{Filter noise from a point cloud}
\usage{
clean_point_cloud(aRchi, k = 5, sigma = 1.5)

\S4method{clean_point_cloud}{aRchi}(aRchi, k = 5, sigma = 1.5)
}
\arguments{
\item{aRchi}{An aRchi object containing a point cloud}

\item{k}{numeric. The number of nearest neighbours to use.}

\item{sigma}{numeric. The multiplier of standard deviation to consider a point as noise.}
}
\value{
The aRchi file with a clean point cloud.
}
\description{
Uses the \code{\link[VoxR]{filter_noise}} function to filter noise from the point cloud.
}
\examples{
# import aRchi file
aRchi=system.file("extdata","Tree_2.aRchi",package = "aRchi")
aRchi = aRchi::read_aRchi(aRchi)

# clean point cloud
aRchi = aRchi::clean_point_cloud(aRchi)

}
