% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_physiological_ages.R
\name{add_physiological_ages}
\alias{add_physiological_ages}
\alias{add_physiological_ages,aRchi-method}
\title{Add the physiological age of an annual shoots based on their length}
\usage{
add_physiological_ages(aRchi, th = c(0.1, 0.2, 0.5), correct_PA = TRUE)

\S4method{add_physiological_ages}{aRchi}(aRchi, th = c(0.1, 0.2, 0.5), correct_PA = TRUE)
}
\arguments{
\item{aRchi}{an object of class aRchi containing at least a QSM.}

\item{th}{numeric. The length thresholds used to segment annual shoots into physiological ages.}

\item{correct_PA}{logical. Should a correction of the physiological age be performed ?
This correction is based on the assumption that the child annual shoot can not be of lower
order than its parent annual shoot. The parent annual shoot physiological age is modified accordingly.}
}
\value{
The aRchi file with a physiological age field added to the QSM slot
}
\description{
Add the physiological age of an annual shoots based on their length
}
\examples{
\donttest{
# import aRchi file
aRchi=system.file("extdata","Tree_2.aRchi",package = "aRchi")
aRchi = aRchi::read_aRchi(aRchi)

# smooth skeleton
aRchi = smooth_skeleton(aRchi)

# segment annual shoots
aRchi = aRchi::segment_annual_shoots(aRchi,tree_age = 13)

# add physiological ages
aRchi = aRchi::add_physiological_ages(aRchi)

plot(aRchi,color="physiological_age",bg = "white")
}
}
\references{
Lecigne, B., Delagrange, S., & Taugourdeau, O. (2021). Annual Shoot Segmentation and
Physiological Age Classification from TLS Data in Trees with Acrotonic Growth. Forests, 12(4), 391.
https://doi.org/10.3390/f12040391
}
