% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-weibull.R
\docType{class}
\name{Zelig-weibull-class}
\alias{Zelig-weibull-class}
\alias{zweibull}
\title{Weibull Regression for Duration Dependent Variables}
\arguments{
\item{formula}{a symbolic representation of the model to be
estimated, in the form \code{y ~ x1 + x2}, where \code{y} is the
dependent variable and \code{x1} and \code{x2} are the explanatory
variables, and \code{y}, \code{x1}, and \code{x2} are contained in the
same dataset. (You may include more than two explanatory variables,
of course.) The \code{+} symbol means ``inclusion'' not
``addition.'' You may also include interaction terms and main
effects in the form \code{x1*x2} without computing them in prior
steps; \code{I(x1*x2)} to include only the interaction term and
exclude the main effects; and quadratic terms in the form
\code{I(x1^2)}.}

\item{model}{the name of a statistical model to estimate.
For a list of other supported models and their documentation see:
\url{http://docs.zeligproject.org/articles/}.}

\item{data}{the name of a data frame containing the variables
referenced in the formula or a list of multiply imputed data frames
each having the same variable names and row numbers (created by
\code{Amelia} or \code{\link{to_zelig_mi}}).}

\item{...}{additional arguments passed to \code{zelig},
relevant for the model to be estimated.}

\item{by}{a factor variable contained in \code{data}. If supplied,
\code{zelig} will subset
the data frame based on the levels in the \code{by} variable, and
estimate a model for each subset. This can save a considerable amount of
effort. You may also use \code{by} to run models using MatchIt
subclasses.}

\item{cite}{If is set to 'TRUE' (default), the model citation will be printed
to the console.}
}
\value{
Depending on the class of model selected, \code{zelig} will return
  an object with elements including \code{coefficients}, \code{residuals},
  and \code{formula} which may be summarized using
  \code{summary(z.out)} or individually extracted using, for example,
  \code{coef(z.out)}. See
  \url{http://docs.zeligproject.org/articles/getters.html} for a list of
  functions to extract model components. You can also extract whole fitted
  model objects using \code{\link{from_zelig_model}}.
}
\description{
Weibull Regression for Duration Dependent Variables
}
\details{
In addition to the standard inputs, zelig() takes the following
additional options for weibull regression:
\itemize{
    \item \code{robust}: defaults to FALSE. If TRUE, zelig() computes
    robust standard errors based on sandwich estimators based on the options in cluster.
    \item \code{cluste}r: if \code{robust = TRUE}, you may select a variable
    to define groups of correlated observations. Let x3 be a variable
    that consists of either discrete numeric values, character strings,
     or factors that define strata. Then
             \code{z.out <- zelig(y ~ x1 + x2, robust = TRUE, cluster = "x3",
               model = "exp", data = mydata)}
    means that the observations can be correlated within the strata defined
    by the variable x3, and that robust standard errors should be calculated according to
    those clusters. If robust=TRUErobust=TRUE but cluster is not specified, zelig() assumes
    that each observation falls into its own cluster.
}

Additional parameters avaialable to this model include:
\itemize{
  \item weights: vector of weight values or a name of a variable in the dataset
  by which to weight the model. For more information see:
  \url{http://docs.zeligproject.org/articles/weights.html}.
  \item bootstrap: logical or numeric. If \code{FALSE} don't use bootstraps to
  robustly estimate uncertainty around model parameters due to sampling error.
  If an integer is supplied, the number of boostraps to run.
  For more information see:
  \url{http://docs.zeligproject.org/articles/bootstraps.html}.
}
}
\section{Methods}{

\describe{
\item{\code{zelig(formula, data, model = NULL, ..., weights = NULL, by,
  bootstrap = FALSE)}}{The zelig function estimates a variety of statistical models}
}}

\examples{
data(coalition)
z.out <- zelig(Surv(duration, ciep12) ~ fract + numst2,model = "weibull", data = coalition)

}
\seealso{
Vignette: \url{http://docs.zeligproject.org/articles/zelig_weibull.html}
}
