% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{to_zelig}
\alias{to_zelig}
\title{Coerce a non-Zelig fitted model object to a Zelig class object}
\usage{
to_zelig(obj)
}
\arguments{
\item{obj}{a fitted model object fitted using \code{lm} and many using
\code{glm}. Note: more intended in future Zelig releases.}
}
\description{
Coerce a non-Zelig fitted model object to a Zelig class object
}
\examples{
library(dplyr)
lm.out <- lm(Fertility ~ Education, data = swiss)

z.out <- to_zelig(lm.out)

# to_zelig called from within setx
setx(z.out) \%>\% sim() \%>\% plot()

}
\author{
Christopher Gandrud and Ista Zhan
}
