/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public abstract class ColumnBuilder {
    protected final ArrayList<DataType> detectedTypes;
    protected final ArrayList<Cell> cells;
    protected final ArrayList<CellValue> values;
    protected final String dateTimeFormat;
    protected final boolean forceConversion;
    protected final boolean takeCached;
    protected final FormulaEvaluator evaluator;
    protected final ErrorBehavior onErrorCell;
    protected final ArrayList<String> warnings = new ArrayList();

    public ColumnBuilder(int nrows, boolean forceConversion, boolean takeCached, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, String dateTimeFormat) {
        this.detectedTypes = new ArrayList(nrows);
        this.cells = new ArrayList(nrows);
        this.values = new ArrayList(nrows);
        this.forceConversion = forceConversion;
        this.evaluator = evaluator;
        this.takeCached = takeCached;
        this.onErrorCell = onErrorCell;
        this.dateTimeFormat = dateTimeFormat;
    }

    public void clear() {
        this.detectedTypes.clear();
        this.cells.clear();
        this.values.clear();
        this.warnings.clear();
    }

    public void addCell(Cell c) {
        try {
            Optional<CellValue> cellValue = Optional.ofNullable(c).map(this::getCellValue);
            if (cellValue.isPresent()) {
                CellValue cv = cellValue.get();
                if (cv.getCellType() == CellType.ERROR) {
                    this.cellError("Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(c.getErrorCellValue()));
                } else {
                    this.handleCell(c, cv);
                }
            } else {
                this.addMissing();
            }
        }
        catch (Exception e) {
            this.cellError("Error when trying to evaluate cell " + CellUtils.formatAsString(c) + " - " + e.getMessage());
        }
    }

    protected void addMissing() {
        this.values.add(null);
        this.cells.add(null);
        this.detectedTypes.add(DataType.Boolean);
    }

    protected void addValue(Cell c, CellValue cv, DataType dt) {
        this.cells.add(c);
        this.values.add(cv);
        this.detectedTypes.add(dt);
    }

    public Column buildBooleanColumn() {
        int size = this.values.size();
        boolean[] colValues = new boolean[size];
        BitSet missing = new BitSet(size);
        int counter = 0;
        for (CellValue cv : this.values) {
            if (cv == null) {
                missing.set(counter);
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue();
                        break;
                    }
                    case Numeric: {
                        colValues[counter] = this.forceConversion && cv.getNumberValue() > 0.0;
                        missing.set(counter, !this.forceConversion);
                        break;
                    }
                    case String: {
                        colValues[counter] = this.forceConversion && Boolean.parseBoolean(cv.getStringValue().toLowerCase());
                        missing.set(counter, !this.forceConversion);
                        break;
                    }
                    case DateTime: {
                        missing.set(counter);
                        this.warnings.add("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from DateTime to Boolean - returning NA");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, size, missing, DataType.Boolean);
    }

    public Column buildDateTimeColumn() {
        int size = this.values.size();
        Date[] colValues = new Date[size];
        BitSet missing = new BitSet(size);
        Iterator<CellValue> it = this.values.iterator();
        Iterator<Cell> jt = this.cells.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            Cell cell = jt.next();
            if (cv == null) {
                missing.set(counter);
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        missing.set(counter);
                        this.warnings.add("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Boolean to DateTime - returning NA");
                        break;
                    }
                    case Numeric: {
                        if (this.forceConversion) {
                            if (DateUtil.isValidExcelDate((double)cv.getNumberValue())) {
                                colValues[counter] = cell.getDateCellValue();
                                break;
                            }
                            missing.set(counter);
                            this.warnings.add("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Numeric to DateTime - returning NA");
                            break;
                        }
                        missing.set(counter);
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            try {
                                colValues[counter] = Workbook.dateTimeFormatter.parse(cv.getStringValue(), this.dateTimeFormat);
                            }
                            catch (Exception e) {
                                missing.set(counter);
                                this.warnings.add("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to DateTime - returning NA - cause: " + e.getClass() + ":" + e.getMessage());
                            }
                            break;
                        }
                        missing.set(counter);
                        break;
                    }
                    case DateTime: {
                        colValues[counter] = cell.getDateCellValue();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, size, missing, DataType.DateTime);
    }

    public Column buildNumericColumn() {
        int size = this.values.size();
        double[] colValues = new double[size];
        BitSet missing = new BitSet(size);
        int counter = 0;
        for (CellValue cv : this.values) {
            if (cv == null) {
                missing.set(counter);
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue() ? 1.0 : 0.0;
                        break;
                    }
                    case Numeric: {
                        colValues[counter] = cv.getNumberValue();
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            try {
                                colValues[counter] = Double.parseDouble(cv.getStringValue());
                            }
                            catch (NumberFormatException e) {
                                missing.set(counter);
                                this.warnings.add("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to Numeric - returning NA");
                            }
                            break;
                        }
                        missing.set(counter);
                        break;
                    }
                    case DateTime: {
                        if (this.forceConversion) {
                            colValues[counter] = cv.getNumberValue();
                            break;
                        }
                        missing.set(counter);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, size, missing, DataType.Numeric);
    }

    public Column buildStringColumn() {
        int size = this.values.size();
        String[] colValues = new String[size];
        BitSet missing = new BitSet(size);
        Iterator<CellValue> it = this.values.iterator();
        Iterator<Cell> jt = this.cells.iterator();
        DataFormatter fmt = new DataFormatter();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            Cell cell = jt.next();
            if (cv == null) {
                missing.set(counter);
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue() ? "true" : "false";
                        break;
                    }
                    case Numeric: {
                        short formatIndex = cell.getCellStyle().getDataFormat();
                        String formatStr = cell.getCellStyle().getDataFormatString();
                        colValues[counter] = fmt.formatRawCellContents(cv.getNumberValue(), (int)formatIndex, formatStr);
                        break;
                    }
                    case DateTime: {
                        colValues[counter] = Workbook.dateTimeFormatter.format(cell.getDateCellValue(), this.dateTimeFormat);
                        break;
                    }
                    case String: {
                        colValues[counter] = cv.getStringValue();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(colValues, size, missing, DataType.String);
    }

    protected void cellError(String msg) {
        if (!this.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
            throw new IllegalArgumentException(msg);
        }
        this.addMissing();
        this.warnings.add(msg);
    }

    public DataType determineColumnType() {
        DataType columnType = DataType.Boolean;
        Iterator<DataType> it = this.detectedTypes.iterator();
        while (it.hasNext() && !columnType.equals((Object)DataType.String)) {
            DataType dt = it.next();
            if (dt.ordinal() <= columnType.ordinal()) continue;
            columnType = dt;
        }
        return columnType;
    }

    protected CellValue getCachedCellValue(Cell cell) {
        CellType valueType = cell.getCellType();
        if (valueType == CellType.FORMULA) {
            valueType = cell.getCachedFormulaResultType();
        }
        switch (valueType) {
            case BLANK: {
                return null;
            }
            case BOOLEAN: {
                if (cell.getBooleanCellValue()) {
                    return CellValue.TRUE;
                }
                return CellValue.FALSE;
            }
            case NUMERIC: {
                return new CellValue(cell.getNumericCellValue());
            }
            case STRING: {
                return new CellValue(cell.getStringCellValue());
            }
            case ERROR: {
                return CellValue.getError((int)cell.getErrorCellValue());
            }
        }
        String msg = String.format("Could not extract value from cell with cached value type %s", valueType);
        throw new RuntimeException(msg);
    }

    protected CellValue getCellValue(Cell cell) {
        if (this.takeCached) {
            return this.getCachedCellValue(cell);
        }
        return this.evaluator.evaluate(cell);
    }

    protected abstract void handleCell(Cell var1, CellValue var2);

    public List<String> getWarnings() {
        return this.warnings;
    }
}

