% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateXI.R
\name{calculateXI}
\alias{calculateXI}
\alias{xicorcoefficient}
\title{Compute the cross rank coefficient xi on two vectors.}
\usage{
calculateXI(xvec, yvec, simple = TRUE, seed = 12133331)
}
\arguments{
\item{xvec}{Vector of numeric values in the first coordinate.}

\item{yvec}{Vector of numeric values in the second coordinate.}

\item{simple}{Whether auxiliary information is kept to pass on.}

\item{seed}{Ties are removed randomly, setting a seed ensures reproducibility.}
}
\value{
In the case simple = TRUE, function returns the value of the
xi
coefficient,
If simple = FALSE is chosen, the function returns a list:
\describe{\item{xi}{The xi coefficient}
\item{fr}{rearranged rank of yvec}
\item{CU}{\code{mean(gr*(1-gr))}}
}
}
\description{
This function computes the xi coefficient between two vectors x and y.
}
\note{
Auxiliary function with no checks for NA, etc.
}
\examples{
# Compute one of the coefficients
library("psychTools")
data(peas)
calculateXI(peas$parent,peas$child)
calculateXI(peas$child,peas$parent)
}
\references{
Chatterjee, S. (2020) A New Coefficient Of Correlation,
<arXiv:1909.10140>.
}
\seealso{
xicor
}
\author{
Sourav Chatterjee, Susan Holmes
}
\keyword{~methods}
