% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Form.R
\name{form_entries}
\alias{form_entries}
\title{Return responses of your form}
\usage{
form_entries(wufoo_name = auth_name(NULL), formIdentifier = NULL,
  systemFields = "true", sortID = NULL, sortDirection = NULL,
  columnNames = FALSE, showRequestURL = FALSE, debugConnection = 0L,
  domain = "wufoo.com", pageStart = 0, pageSize = 25)
}
\arguments{
\item{wufoo_name}{- User's Name. Default: \code{\link{auth_name}}}

\item{formIdentifier}{- must be replaced with your form's URL or hash.}

\item{systemFields}{- return system fields. Default: true}

\item{sortID}{- sort on a single ID, as retrieved from the \code{\link{fields_info}}.}

\item{sortDirection}{- choose to sort your entries ASC (lowest to highest) or DESC (highest to lowest).}

\item{columnNames}{- a MUST: How should be column names be called. Either "Field1", "Field2" 
etc. or "First Name", "Last Name" (tries to make best guess). Default to the second option.}

\item{showRequestURL}{- use only for DEBUG purposes}

\item{debugConnection}{- samilar as above. Either "0L" (false; default) or "1L"}

\item{domain}{- for thatever reason domain's ccTLD may change. With this param you can change 
default \code{wufoo.com} to another one such as \code{wufoo.eu}}

\item{pageStart}{- the page number you'd like to start from.  Defaults to 0.}

\item{pageSize}{- the number of entries returned in your page. Defaults to 25; Max = 100.}
}
\value{
EntryId - This value is the unique identifier for your entry.

DateCreated - The date that this entry was submitted.

Created By - The person who created the entry. If submitted through a form, the value 
here will be public. If the submission originated in the Entry Manager this value will be the 
user name of the submitting user.

DateUpdated - The date that this entry was edited through the Entry Manager. If the 
submission has never been updated, this value will be blank.

UpdatedBy - The user name of the person who updated the entry in the Entry Manager will 
appear in this element.
}
\description{
If you have 5 submissions to your form, you'll have 5 elements (rows) in the return.
}
\examples{
form_entries(formIdentifier = "z5kqx7h1gtvg4g")
form_entries(formIdentifier = "z5kqx7h1gtvg4g", systemFields = "false", showRequestURL = TRUE)

}
\seealso{
\url{http://help.wufoo.com/articles/en_US/SurveyMonkeyArticleType/The-Entries-GET-API}
}

