% Generated by roxygen2 (4.0.2): do not edit by hand
\name{wiki_userinfo}
\alias{wiki_userinfo}
\title{Retrieve user information}
\usage{
wiki_userinfo(con, usernames, properties = c("blockinfo", "groups",
  "implicitgroups", "rights", "editcount", "registration", "emailable",
  "gender"))
}
\arguments{
\item{con}{A connector object, generated by \code{\link{wiki_con}},
that corresponds to the project you're trying to query.}

\item{usernames}{The username(s) of the users you want information on - this should be provided
as a vector. There is a hard limit of 50 distinct users per query, set by MediaWiki's API;
in the event that you go over this, a warning will be issued and the query will only be
performed for the first 50 names in the vector.}

\item{properties}{The user properties you're interested in. Applicable properties are
"blockinfo" (details about the user's block, if they are currently blocked), "groups"
(the user groups the user is a member of), "implicitgroups" (groups they are a member of
through inheritance, as a result of membership in other groups), "rights" (what permissions
their group membership grants them), "editcount" (how many non-deleted edits they have),
"registration" (the date when they registered), "emailable" (whether they are contactable
through Special:EmailUser) and "gender" (their provided gender).}
}
\description{
Retrieves information about a user, or set of users, from the MediaWiki API,
including registration date, gender and editcount.
}
\section{Warnings}{

There are a few caveats with the data provided by \code{wiki_userinfo}, mostly stemming from
historical inconsistencies and peculiarities in MediaWiki.

\code{groups} and \code{implicitgroups} gives you the user's permissions and group membership
on the project you are querying, not their membership on all projects - while you can find out
if "Ironholds" is not a sysop on, say, enwiki, that doesn't mean they aren't a sysop elsewhere
- there is no universal, API-accessible user groups listing.

As an extension of the lack of centrality in Wikimedia's infrastructure, \code{registration}
tells you the date their account was created on the wiki you are querying. If they initially
registered on that wiki, this is accurate - if they registered on a different wiki,
this instead reflects the date and time that they first visited the wiki you're querying
while logged-in. For users registered before 2006, when registration logging was introduced,
the \code{registration} value represents not when they first registered, but when their first
edit was, since that was used as an estimator for existing accounts when the field was first
populated.
}

