#'@title Retrieves MediaWiki page content
#'
#'@description
#'wiki_page retrieves the DOM of a particular MediaWiki page,
#'as a HTML blob inside a JSON object.
#'
#'@param con A connector object, generated by \code{\link{wiki_con}},
#'that corresponds to the project you're trying to query.
#'
#'@param page The title of the page you want to retrieve
#'
#'@param properties Properties associated with the page, namely "text" (the actual, HTML content)
#'and "revid" (the revision ID of the current version), the latter of which allows you to use
#'\code{\link{wiki_revision}} to retrieve the underlying wikitext.
#'
#'@seealso \code{\link{wiki_diff}} for retrieving 'diffs' between revisions,
#'\code{\link{wiki_revision}} for retrieving the text of specified revisions.
#'
#'@export

#Retrieves the most recent revision for each provided page title.
wiki_page <- function(con, page, properties = c("text","revid")) {
  
  #Format and standardise pages and properties
  page <- handle_limits(page, 1)
  properties <- match.arg(arg = properties, several.ok = TRUE)
  properties <- paste(properties, collapse = "|")
  
  #Construct query to retrieve the parsed DOM of the page
  page_url <- paste(con$URL, "&contentformat=application/json&action=parse&page=", page, "&prop=", properties, sep = "")

  #Run  
  page_content <- wiki_call(URL = page_url, con$Config)
  
  #Return
  return(page_content)
}