% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smilies.R
\name{plot_smilies}
\alias{plot_smilies}
\title{Visualize smilies used in 'WhatsApp' chat logs}
\usage{
plot_smilies(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = as.character(as.POSIXct(Sys.time(), tz = "UTC")),
  min_occur = 1,
  return_data = FALSE,
  smilie_vec = "all",
  plot = "bar",
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chat log that was parsed with \code{\link[WhatsR]{parse_chat}}.}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{min_occur}{The minimum number of occurrences a smiley has to have to be included in the visualization. Default is 1.}

\item{return_data}{If TRUE, returns a data frame of smilies extracted from the chat for more elaborate plotting. Default is FALSE.}

\item{smilie_vec}{A vector of smilies that the visualizations will be restricted to.}

\item{plot}{The type of plot that should be returned. Options are "heatmap", "cumsum", "bar" and "splitbar".}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from the data. Default is FALSE.}
}
\value{
Plots for distribution of smilies in 'WhatsApp' chats
}
\description{
Plots the smilies used in 'WhatsApp' chat logs by sender
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_smilies(data)
}
