\name{pivotal.rr}
\alias{pivotal.rr}

\title{Pivotal 'Monte Carlo' re-sampling of least squares linear regression models}

\description{
This function implements a fast pivotal engine enabling a wide assortment of options for linear regression models  for the Abernethy Reliability Methods project. Pivotal analysis is used to determine a goodness of fit measure and confidence interval bounds.
}

\usage{
pivotal.rr(x, event=NULL, dist="weibull", reg_method="XonY", R2, CI, unrel=NULL,
  P1=1.0, P2=1.0, S=10^4,seed=1234, ProgRpt=FALSE) 
}

\arguments{
  \item{x}{A dataframe such as generated by getPPP with column names 'data' and 'ppp'.}
  \item{event}{An optional integer vector with 0's identifying the rank position of suspension data for sample masking.  Event masking will modestly narrow the confidence interval consistent with the addition of information.  The user has full control over determination of significance of the suspension data for this process.}
  \item{dist}{A string defining a distribution to be fit. Implemented distributions are "weibull" (default), "lnorm", and "gumbel" (Extreme Value Type 1)}
  \item{reg_method}{A string defining the order of regression whether "XonY" axis(default and "best practice for standard small sample fitting) or "YonX" axis for alternative study ("YonX" recommended for an inspection option by Abernethy).}
  \item{R2}{Output control: for prr and ccc2 the explained variance (R squared) from a linear regression of a data sample of interest. An entry of 0 (zero) suppresses output, 1.0 requests the entire vector of r^2 values.}
  \item{CI}{Output control: for the bounds provide the double sided confidence interval of interest. An entry of 0 (zero) suppresses output, 1.0 requests an entire matrix of generated values.}
  \item{unrel}{An optional vector of unreliability values to be used as the descriptive quantiles at which the bounds will be calculated.}
  \item{P1}{The scale parameter to be used in random sampling.  Default = 1.0 (For lnorm or gumbel distributions this most likely will be preferred to be set to zero.)}
  \item{P2}{The shape parameter to be used in random sampling. Default = 1.0}
  \item{S}{The number of random samples to be drawn for Monte Carlo simulation. S must be a multiple 
  of 10.  If S is less than 1,000 R2 and/or CI will be altered from non-zero quantities to 1.0 to return the full vector of R2 CDF or the full matrix of pivotal values.  The default of 10^4 is adequate for most instances. S is implemented as an unsigned int in C++ code.  The maximum limit is 4x10^9 if system memory permits.}
 \item{seed}{an integer used to set the RNG seed.  Default = 1234}
 \item{ProgRpt}{A boolean value to control the generation of percent completion feedback in the R terminal.}
}

\details{
Pivotal quantities are determined by establishing the x-axis value at each descriptive quantile position for each sampled regression.  The output pivotals determined at the double sided confidence interval must be interpreted for application to any given data fit.
}

\value{
Returns an appropriate object for the input R2 and CI values.  There are 8 output configurations that can be generated depending on the argument values for R2 (for r^2, coefficient of determination) and CI (for confidence interval).   When either of these values is entered as zero, no output for the corresponding prr value or confidence interval are generated.  Specifically defined input values for either argument are in the range 0.0<value<1.0 .  When a specifically defined value has been provided the output for R2 will be a vector containing the prr value and the CCC^2.  The output for a specifically defined CI will be a dataframe containing the pivotal quantities.  Should an absolute value of 1.0 be given for either R2 or CI then a full vector of the r^2 CDF, or the full matrix of pivotal quantities generated for all samples will be returned.  When non-zero entries are provided for both R2 and CI the appropriate output objects are returned in a list.
}

\references{
  Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition"
  
  Jerald F. Lawless, (2003) "Statistical Models and Methods for Lifelime Data, Second Edition" 
  
  John I. McCool, (2012) "Using the Weibull Distribution: Reliability, Modeling and Inference"
  
  Chi-Chao Lui, "A Comparison Between The Weibull And Lognormal Models Used To Analyse Reliability Data"
 (dissertation from University of Nottingham, 1997)
  }

\examples{
failures<-c(90,96,30,49,82)
suspensions<-c(100,45,10)
data_positions<-getPPP(failures,suspensions)
fit<-lslr(data_positions)
prr_value<-pivotal.rr(data_positions,R2=fit[3],CI=0, unrel=.5)
## note: unrel value has no meaning when CI=0
}

\keyword{ regression reliability }