\name{lslr}
\alias{lslr}

\title{Least squares linear regression with many optional methods}

\description{
This function implements a wide assortment of options for linear regression fitting of distributions specific to reliability analysis for the Abernethy Reliability Methods project.
}

\usage{
lslr(x, dist="weibull", npar=2, reg_method="XonY") 
}

\arguments{
  \item{x}{A dataframe such as generated by getPPP with column names 'data' and 'ppp'.}
  \item{dist}{A string defining a distribution to be fit. Implemented distributions are "weibull" (default), "lnorm", and "gumbel" (Extreme Value Type 1)}
  \item{npar}{Number of parameters to evaluate. This really is only looking for potential value of 3 for 3rd parameter optimization.  Any other value will resolve the same as default of 2.}
  \item{reg_method}{A string defining the order of axes presented for regression, whether "XonY" axis(default) or "YonX" axis for alternative study.}
}


\value{
Returns a named vector with parameters of the distribution fit and goodness of fit in terms of R squared.
}

\references{
  Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition"
  Leonard C. Johnson (1964) "The Statistical Treatment of Fatique Experiments"  
}

\examples{
failures<-c(90,96,30,49,82)
suspensions<-c(100,45,10)
default_weibull_fit<-lslr(getPPP(failures,suspensions))
}

\keyword{ regression reliability }