% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryYScatterPlot.R
\name{BinaryYScatterPlot}
\alias{BinaryYScatterPlot}
\title{Plot a scatter plot of a binary variable with smoothing curve.}
\usage{
BinaryYScatterPlot(frame, xvar, yvar, title, ..., se = FALSE,
  use_glm = TRUE)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent column in frame}

\item{yvar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{se}{if TRUE, add error bars (defaults to FALSE). Ignored if useGLM is TRUE}

\item{use_glm}{if TRUE, "smooths" with a one-variable logistic regression (defaults to TRUE)}
}
\description{
Plot the scatter plot of a binary variable with a smoothing curve.
}
\details{
The points are jittered for legibility. By default, a logistic regression fit is
used, so that the smoothing curve represents the probability of y == 1 (as fit by
the logistic regression). If
\code{use_glm} is set to FALSE, a standard smoothing curve (either loess or a
spline fit) is used.
}
\examples{

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(x=x,y=y,yC=y>=as.numeric(quantile(y,probs=0.8)))
frm$absY <- abs(frm$y)
frm$posY = frm$y > 0
frm$costX = 1
WVPlots::BinaryYScatterPlot(frm, "x", "posY",
   title="Example 'Probability of Y' Plot")

}
