% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrtdsrsd.R
\name{wrtdsrsd}
\alias{wrtdsrsd}
\alias{wrtdsrsd.tidal}
\alias{wrtdsrsd.tidalmean}
\title{Get WRTDS residuals}
\usage{
wrtdsrsd(dat_in, ...)

\method{wrtdsrsd}{tidal}(dat_in, trace = TRUE, ...)

\method{wrtdsrsd}{tidalmean}(dat_in, trace = TRUE, ...)
}
\arguments{
\item{dat_in}{input tidal object which must already have fitted model data}

\item{...}{arguments passed to or from other methods}

\item{trace}{logical indicating if progress is shown in the console}
}
\value{
Columns are added to the data of the tidal object for residuals and non-conditional residuals. Both are required to assess the goodness of fit measure described for quantile regression in Koenker and Machado (1999).

A tidal object with columns added to the \code{predonobs} attribute for the residuals ('rsd') and non-conditional residuals ('rsdnl') of each quantile model or a tidalmean object with columns added to the \code{predonobs} attribute for the residuals ('rsd') and back-transformed residuals ('bt_rsd').
}
\description{
Get WRTDS residuals for each quantile model. These are used to estimate goodness of fit of the model predictions.
}
\examples{
## load a fitted model object
data(tidfit)

## run the function
res <- wrtdsrsd(tidfit)
head(res)
}
\references{
Koenker, R., Machado, J.A.F. 1999. Goodness of fit and related inference processes for quantile regression. Journal of the American Statistical Association. 94(448):1296-1310.
}
\seealso{
\code{\link{wrtds}}, \code{\link{wrtdsperf}}, \code{\link{goodfit}}
}

