% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_admin_data.R
\name{get_admin_data}
\alias{get_admin_data}
\title{Get administrative data for a set of points}
\usage{
get_admin_data(lon, lat, path_admin_data)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}

\item{path_admin_data}{The file path to the admin data. Note that the function expects .shp
format output from the \code{download_admin_data} function or from another user supplied source.}
}
\value{
data.frame
}
\description{
This function takes a set of longitude and latitude coordinates and retrieves the administrative
units that each point lies within.
}
\examples{
\donttest{

download_admin_data(iso3 = "MCO",
                    release = 'gbOpen',
                    path_output = tempdir())

get_admin_data(lon = c(7.416, 7.434),
               lat = c(43.734, 43.747),
               path_admin_data = file.path(tempdir(), 'MCO_admin_levels.shp'))

}
}
