% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet_variance.R
\name{wave.var}
\alias{wave.var}
\title{Produces an estimate of the multiscale variance along with approximate confidence intervals.}
\usage{
wave.var(x, type = "eta3", p = 0.025)
}
\arguments{
\item{x}{DWT/MODWT/AT object}

\item{type}{character string describing confidence interval calculation; valid methods are gaussian, eta1, eta2, eta3, nongaussian}

\item{p}{(one minus the) two-sided p-value for the confidence interval}
}
\value{
Dataframe with as many rows as levels in the wavelet transform object. The first column provides the point estimate for the wavelet variance followed by the lower and upper bounds from the confidence interval.
}
\description{
Produces an estimate of the multiscale variance along with approximate confidence intervals.
}
\references{
Percival, D. B. (1995) Biometrika, 82, No. 3, 619-631.
}
