% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{add_item}
\alias{add_item}
\title{Define or append model inputs}
\usage{
add_item(..., .data = NULL, input)
}
\arguments{
\item{...}{Unevaluated arguments. Named → \code{name <- expr}; unnamed → raw expr.}

\item{.data}{Optional named argument: an existing \code{{}} block (or list of
expressions) to start from.}

\item{input}{Optional unevaluated expression or \code{{}} block to splice in.}
}
\value{
A single \code{{}} call (language object) ready for \code{load_inputs()}.
}
\description{
Build a single \code{{}} expression that defines inputs for a simulation.
\itemize{
\item Named args in \code{...} become assignments (\code{name <- expr}), e.g., \code{add_item(a=5)}
\item Unnamed args are inserted raw/unevaluated. If an unnamed arg is a \code{{}} block,
its statements are spliced (flattened). \code{add_item(pick_val_v(...))}
\item Works with magrittr pipes: a leading \code{.} (the LHS) is resolved to its value;
if that value is a \code{{}} block (or list of expressions), it becomes the
starting block.
\item input argument can be used to handle alternative \code{add_item2} method,
e.g. \code{add_item(input = {a <- 5})}
}
}
\examples{
library(magrittr)

add_item(input = {fl.idfs <-  0})
add_item(input = {
 util_idfs <- if(psa_bool){rnorm(1,0.8,0.2)} else{0.8}
 util.mbc <- 0.6
 cost_idfs <- 2500})
common_inputs <- add_item(input = {
pick_val_v(
  base      = l_statics[["base"]],
  psa       = pick_psa(
    l_statics[["function"]],
    l_statics[["n"]],
    l_statics[["a"]],
    l_statics[["b"]]
  ),
  sens      = l_statics[[sens_name_used]],
  psa_ind   = psa_bool,
  sens_ind  = sensitivity_bool,
  indicator = indicators_statics,
  names_out = l_statics[["parameter_name"]],
  deploy_env = TRUE #Note this option must be active if using it at add_item2
)
}
) 

}
