% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patientchartcode.R
\name{cchart}
\alias{cchart}
\alias{cchart.coxph}
\alias{cchart.default}
\alias{cchart.glm}
\alias{cchart.ksvm}
\alias{cchart.multinom}
\title{Contribution chart.}
\usage{
cchart(x, obs, filename, zerolevel = "zero", risklabel, sorted = FALSE,
  time, xmin, xmax)
}
\arguments{
\item{x}{\code{glm}, \code{coxph}, \code{mfp}, \code{multinom} or \code{ksvm} object.}

\item{obs}{A data.frame containing the predictor values of the observation for which the chart should be made.}

\item{filename}{The name of the resulting file (default: cchart).}

\item{zerolevel}{The value of the contributions that should be put to zero.  If "zero", the contributions are represented 
   as they are.  If "min", for each predictor or set of predictors contributing to an interaction, the minimal observed value 
   of the contribution in the training data is substracted from the contribution to ensure that the contribution is always positive.  
If "median" or "mean", the median or mean value is substracted from the contributions, respectively (default="zero").  See below for more details.}

\item{risklabel}{A character string representing the label for the represented risk. For  multinomial logistic regression models, a vector of risk labels should be provided. 
See the examples for an illustration of the approach.}

\item{sorted}{logical.  If TRUE the contributions are sorted in increasing order (default=FALSE).}

\item{time}{The time at which the estimated survival should be calculated.  As default, the estimated survival at median survival time is reported.  If the median 
survival time can not be calculated, the estimated survival at the latest event time is reported.  For objects that are not a member of the \code{coxph} class, this is redundant.}

\item{xmin}{Minimal values of input variables to be represented on the visualization.  These values only have an influence on continuous input variables.}

\item{xmax}{Maximal values of input variables to be represented on the visualization.  These values only have an influence on continuous input variables.}
}
\description{
Display a graph explaining how the risk prediction of a new observation is obtained from the model.
	All contributions to the linear predictor or latent variable are visualized and summed to obtain the linear predictor.  The latter is then 
	transformed into a risk estimate.
}
\details{
The contribution chart is a bar plot representing the contribution of each predictor or set of predictors to the score (translated linear predictor)
	by means of bars.   Depending on the value of \code{zerolevel}, the visualized contributions are slightly different.  
	If \code{zerolevel}="zero", the contribution for variable \eqn{x^p} is \eqn{\beta_pf_p(x^p)}, with \eqn{\beta_p} the model
	coefficient corresponding to this predictor and \eqn{f_p(x^p)} a (possible) transformation of \eqn{x^p}.  If \code{zerolevel} is "min", "median" or "mean", a value equal to 
	the minimum, median and mean of the contribution \eqn{\beta_pf_p(x^p)} in the training data, respectively, is substracted from the contribution.  See the references for more information.
	The sum of all the contributions is the score (i.e. translated linear predictor or latent variable) which is transformed into the risk estimate.  
	The range of all contributions in the training set are visualized by means of black horizontal lines.
}
\note{
This graph can not be used for cox proportional hazard regression including strata.

For \code{coxph} models, it is necessary to include \code{model=TRUE} in the model fit.

For \code{multinom} models, it is necessary to include \code{model=TRUE} in the model fit.

For \code{multinom} models, more than one output file is generated.  A first series of plots visualizes how the linear predictors are obtained.  The files
	are named "filename_outcome_level_cchart", with "outcome_level" the name of the outcome level for which the linear predictor is visualized.  A second series of plots
	visualizes how the linear predictors are transformed into a risk prediction for each outcome level.  The files are named "filename_p_outcome_level_cchart".

For \code{multinom} models,  a vector of risk labels needs to be made and provided to the \code{cchart()} function.  See the examples for an illustration of the approach.

For \code{ksvm} models, it is necessary to include \code{prob.model=TRUE} in the model fit.

The plot is not shown in a graphical window but saved in the current working directory.

In case \code{zerolevel="min"} and \code{xmin} and \code{xmax} are provided by the user, it is possible to have negative contributions within the training data.
}
\examples{
#### logistic regression
mydata <- read.csv("http://www.ats.ucla.edu/stat/data/binary.csv")
mydata$rank <- factor(mydata$rank)
fit <- glm(admit ~ gre + gpa + rank, data = mydata, family = "binomial")
patient1=data.frame(gre=386,gpa=3.58,rank=3)
cchart(fit,obs=patient1,filename="cchart1")

#### cox proportional hazard regression
library(mfp)
data(GBSG)
fit<-coxph(Surv(rfst, cens) ~ age+tumsize+posnodal+prm+esm+menostat+tumgrad, data = GBSG, 
		model=TRUE)
patient1=data.frame(age=52,tumsize=45,posnodal=23,prm=1025,esm=562,menostat=2,tumgrad=3)
# Indicate the risk estimate at 500 days
cchart(fit,patient1,time=500,filename="cchart6")


#### multinomial logistic regression model
library(nnet)
library(VGAMdata)
data(xs.nz)
marital.nz <- xs.nz[,c("marital","sex","age","height","weight")]
mydata <- marital.nz[complete.cases(marital.nz),]
fit <- multinom(marital ~ sex + age + height + weight, data = mydata,model=TRUE)
# for multinimial logistic regression, a vector of risk labels needs to be made 
# and provided to the colplot function
outnames=colnames(fitted(fit))
labels=c(paste("Linear predictor for",outnames[-1]),paste
				("Predicted chance of being",outnames))
patient1=data.frame(sex="F",age=27,height=1.68,weight=58.6)
cchart(fit,obs=patient1,filename="multinom",risklabel=labels,zerolevel="zero")

#### Support Vector Machine classifier
\dontrun{
	library(kernlab)
	data(iris)
	levels(iris$Species)[levels(iris$Species)=="setosa"] <- "other"
	levels(iris$Species)[levels(iris$Species)=="virginica"] <- "other"
	names(iris)=c("SL","SW","PL","PW","Species")
	set.seed(100)
	model <-ksvm(Species ~ ., data = iris,prob.model=TRUE,kpar=list(0.03),C=10)
	obs1=data.frame(SL=5.2,SW=3.0,PL=1.5,PW=0.3)
# The plot should be based on all training data, so the following code should be used:
	newmodel=preplotperf(model,iris,indy=5,zerolevel="median")
	cchart(newmodel,obs=obs1,filename="iris2",zerolevel="median")
}
}
\author{
Vanya Van Belle
}
\references{
Van Belle V., Van Calster B., \emph{Visualizing risk prediction models}, PLoS ONE, 10(7):e0132614. doi:10.1371/journal.pone.0132614 (2015).

Van Belle V., Van Calster B., Suykens J.A.K., Van Huffel S. and Lisboa P., \emph{Explaining support vector machines: a color based nomogram}, Internal Report 16-27, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016

Van Belle V., Van Huffel S., Timmerman D., Froyman W., Bourne T. and Van Calster B., \emph{A color based nomogram for Multinomial Logistic Regression}, Internal Report 16-28, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016
}
\seealso{
\code{\link{colplot}}, \code{\link{ccchart}}
}

