% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchImpute.R
\name{matchImpute}
\alias{matchImpute}
\title{Fast matching/imputation based on categorical variable}
\usage{
matchImpute(data, variable = colnames(data)[!colnames(data) \%in\% match_var],
  match_var, imp_var = TRUE, imp_suffix = "imp")
}
\arguments{
\item{data}{data.frame, data.table, survey object or matrix}

\item{variable}{variables to be imputed}

\item{match_var}{variables used for matching}

\item{imp_var}{TRUE/FALSE if a TRUE/FALSE variables for each imputed
variable should be created show the imputation status}

\item{imp_suffix}{suffix for the TRUE/FALSE variables showing the imputation
status}
}
\value{
the imputed data set.
}
\description{
Suitable donors are searched based on matching of the categorical variables.
The variables are dropped in reversed order, so that the last element of
'match_var' is dropped first and the first element of the vector is dropped last.
}
\details{
The method works by sampling values from the suitable donors.
}
\examples{

data(sleep,package="VIM")
imp_data <- matchImpute(sleep,variable=c("NonD","Dream","Sleep","Span","Gest"),
  match_var=c("Exp","Danger"))

data(testdata,package="VIM")
imp_testdata1 <- matchImpute(testdata$wna,match_var=c("c1","c2","b1","b2"))

dt <- data.table(testdata$wna)
imp_testdata2 <- matchImpute(dt,match_var=c("c1","c2","b1","b2"))


}
\seealso{
\code{\link[VIM]{hotdeck}}
}
\author{
Johannes Gussenbauer, Alexander Kowarik
}
\keyword{manip}
