\name{colormapMiss}
\alias{colormapMiss}
\alias{colormapMissLegend}
\title{Colored map with information about missing/imputed values}
\usage{
  colormapMiss(x, region, map, imp_index = NULL,
    prop = TRUE, polysRegion = 1:length(x), range = NULL,
    n = NULL, col = c("red", "orange"), gamma = 2.2,
    fixup = TRUE, coords = NULL, numbers = TRUE,
    digits = 2, cex.numbers = 0.8, col.numbers = par("fg"),
    legend = TRUE, interactive = TRUE, ...)

  colormapMissLegend(xleft, ybottom, xright, ytop, cmap,
    n = 1000, horizontal = TRUE, digits = 2,
    cex.numbers = 0.8, col.numbers = par("fg"), ...)
}
\arguments{
  \item{x}{a numeric vector.}

  \item{region}{a vector or factor of the same length as
  \code{x} giving the regions.}

  \item{map}{an object of any class that contains polygons
  and provides its own plot method (e.g.,
  \code{"SpatialPolygons"} from package \code{sp}).}

  \item{imp_index}{a logical-vector indicating which values
  of \sQuote{x} have been imputed. If given, it is used for
  highlighting and the colors are adjusted according to the
  given colors for imputed variables (see \code{col}).}

  \item{prop}{a logical indicating whether the proportion
  of missing/imputed values should be used rather than the
  total amount.}

  \item{polysRegion}{a numeric vector specifying the region
  that each polygon belongs to.}

  \item{range}{a numeric vector of length two specifying
  the range (minimum and maximum) of the proportion or
  amount of missing/imputed values to be used for the color
  scheme.}

  \item{n}{for \code{colormapMiss}, the number of equally
  spaced cut-off points for a discretized color scheme.  If
  this is not a positive integer, a continuous color scheme
  is used (the default).  In the latter case, the number of
  rectangles to be drawn in the legend can be specified in
  \code{colormapMissLegend}.  A reasonably large number
  makes it appear continuously.}

  \item{col}{the color range (start end end) to be used.
  RGB colors may be specified as character strings or as
  objects of class "\code{\link[colorspace]{RGB}}".  HCL
  colors need to be specified as objects of class
  "\code{\link[colorspace]{polarLUV}}".  If only one color
  is supplied, it is used as end color, while the start
  color is taken to be transparent for RGB or white for
  HCL.}

  \item{gamma}{numeric; the display \emph{gamma} value (see
  \code{\link[colorspace]{hex}}).}

  \item{fixup}{a logical indicating whether the colors
  should be corrected to valid RGB values (see
  \code{\link[colorspace]{hex}}).}

  \item{coords}{a matrix or \code{data.frame} with two
  columns giving the coordinates for the labels.}

  \item{numbers}{a logical indicating whether the
  corresponding proportions or numbers of missing/imputed
  values should be used as labels for the regions.}

  \item{digits}{the number of digits to be used in the
  labels (in case of proportions).}

  \item{cex.numbers}{the character expansion factor to be
  used for the labels.}

  \item{col.numbers}{the color to be used for the labels.}

  \item{legend}{a logical indicating whether a legend
  should be plotted.}

  \item{interactive}{a logical indicating whether more
  detailed information about missing/imputed values should
  be displayed interactively (see \sQuote{Details}).}

  \item{xleft}{left \emph{x} position of the legend.}

  \item{ybottom}{bottom \emph{y} position of the legend.}

  \item{xright}{right \emph{x} position of the legend.}

  \item{ytop}{top \emph{y} position of the legend.}

  \item{cmap}{a list as returned by \code{colormapMiss}
  that contains the required information for the legend.}

  \item{horizontal}{a logical indicating whether the legend
  should be drawn horizontally or vertically.}

  \item{\dots}{further arguments to be passed to
  \code{plot}.}
}
\value{
  \code{colormapMiss} returns a list with the following
  components: - nmiss a numeric vector containing the
  number of missing/imputed values in each region. - nobs a
  numeric vector containing the number of observations in
  each region. - pmiss a numeric vector containing the
  proportion of missing values in each region. - prop a
  logical indicating whether the proportion of
  missing/imputed values have been used rather than the
  total amount. - range the range of the proportion or
  amount of missing/imputed values corresponding to the
  color range. - n either a positive integer giving the
  number of equally spaced cut-off points for a discretized
  color scheme, or \code{NULL} for a continuous color
  scheme. - start the start color of the color scheme. -
  end the end color of the color scheme. - space a
  character string giving the color space (either
  \code{"rgb"} for RGB colors or \code{"hcl"} for HCL
  colors). - gamma numeric; the display \emph{gamma} value
  (see \code{\link[colorspace]{hex}}). - fixup a logical
  indicating whether the colors have been corrected to
  valid RGB values (see \code{\link[colorspace]{hex}}).
}
\description{
  Colored map in which the proportion or amount of
  missing/imputed values in each region is coded according
  to a continuous or discrete color scheme. The sequential
  color palette may thereby be computed in the \emph{HCL}
  or the \emph{RGB} color space.
}
\details{
  The proportion or amount of missing/imputed values in
  \code{x} of each region is coded according to a
  continuous or discrete color scheme in the color range
  defined by \code{col}.  In addition, the proportions or
  numbers can be shown as labels in the regions.

  If \code{interactive} is \code{TRUE}, clicking in a
  region displays more detailed information about
  missing/imputed values on the console.  Clicking outside
  the borders quits the interactive session.
}
\note{
  Some of the argument names and positions have changed
  with versions 1.3 and 1.4 due to extended functionality
  and for more consistency with other plot functions in
  \code{VIM}.  For back compatibility, the arguments
  \code{cex.text} and \code{col.text} can still be supplied
  to \code{\dots{}} and are handled correctly.
  Nevertheless, they are deprecated and no longer
  documented.  Use \code{cex.numbers} and
  \code{col.numbers} instead.
}
\author{
  Andreas Alfons, modifications to show imputed values by
  Bernd Prantner
}
\references{
  M. Templ, A. Alfons, P. Filzmoser (2012) Exploring
  incomplete data using visualization tools.  \emph{Journal
  of Advances in Data Analysis and Classification}, Online
  first. DOI: 10.1007/s11634-011-0102-y.
}
\seealso{
  \code{\link{colSequence}}, \code{\link{growdotMiss}},
  \code{\link{mapMiss}}
}
\keyword{hplot}

