% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{getMM}
\alias{getMM}
\title{Overparameterized Design Matrices.}
\usage{
getMM(form, Data, keep.order = TRUE)
}
\arguments{
\item{form}{(formula) with or without response specifying the model to be fit}

\item{Data}{(data.frame) with the data}

\item{keep.order}{(logical) TRUE = terms in 'form' should keep their positions, otherwise
main effects come first and all interactions will be put into increasing order}
}
\description{
Function \code{getMM} constructs overparameterized design matrices from a model formula and a data.frame.
}
\details{
This function constructs the overparameterized design matrix for a given dataset 'Data' according to
the model formula 'form'. Each combination of factor-levels and or numeric variables is identified
and accounted for by a separate column. See examples for differences compared to function 'model.matrix' (stats).
This type of design matrix is used e.g. in constructing A-matrices of quadratic forms in \eqn{y} expressing
ANOVA sums of squares as such. This is key functionality of functions \code{\link{anovaVCA}} and \code{\link{anovaMM}}
used e.g. in constructing the coefficient matrix \eqn{C} whose inverse is used in solving for ANOVA Type-1 based
variance components..
}
\examples{
\dontrun{
# load example data (CLSI EP05-A2 Within-Lab Precision Experiment)
data(dataEP05A2_3)
tmpData <- dataEP05A2_3[1:10,] 

# check out the differences
getMM(~day+day:run, tmpData)
model.matrix(~day+day:run, tmpData)

# adapt factor variables in 'tmpData'
tmpData$day <- factor(tmpData$day)

# check out the differences now
getMM(~day+day:run, tmpData)
model.matrix(~day+day:run, tmpData)

# numeric covariate 'cov'
tmpData2 <- dataEP05A2_3[1:10,] 
tmpData2$cov <- 10+rnorm(10,,3)
model.matrix(~day*cov, tmpData2)
}

}
\seealso{
\code{\link{getAmatrix}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
