% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vca.R
\name{lmerMatrices}
\alias{lmerMatrices}
\title{Derive and Compute Matrices for Objects Fitted by Function 'lmer'.}
\usage{
lmerMatrices(obj, tab = NULL, terms = NULL, cov = FALSE, X = NULL)
}
\arguments{
\item{obj}{(object) inheriting form 'lmerMod'}

\item{tab}{(data.frame) representing the basic VCA-table}

\item{terms}{(character) vector used for ordering variance components}

\item{cov}{(logical) take non-zero covariances among random effects into account (TRUE) or
not (FALSE), the latter is the default in this package and also implemented in
\code{\link{remlVCA}}, \code{\link{anovaVCA}}, and \code{\link{anovaMM}}.}

\item{X}{(matrix) design matrix of fixed effects as constructed to meet VCA-package requirements}
}
\value{
(list), a premature 'VCA' object
}
\description{
Function derives and computes all matrices required for down-stream
analyses of VCA-objects fitted with REML via function \code{\link{lmer}}.
}
\details{
Mixed Model Equations (MME) are solved for fixed and random effects applying the same
constraints as in \code{\link{anovaMM}}.
The most elaborate and therefore time consuming part is to prepare all matrices required for
approximating the variance-covariance matrix of variance components (\code{\link{getGB}}.
To reduce the computational time, this function tries to optimize object-classes depending
on whether Intel's (M)ath (K)ernel (L)ibrary could be loaded or not. MKL appears to be more
performant with ordinary matrix-objects, whereas all other computations are perfomred using
matrix-representations of the \code{Matrix}-package.

This function is not intended to be called directly by users and therefore not exported.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
\seealso{
\code{\link{remlVCA}}, \code{\link{remlMM}}
}

