% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vca.R
\name{vcovVC}
\alias{vcovVC}
\title{Calculate Variance-Covariance Matrix of Variance Components of 'VCA' objects.}
\usage{
vcovVC(obj, method = NULL)
}
\arguments{
\item{obj}{... (VCA) object}

\item{method}{... (character) string, optionally specifying whether to use the algorithm given in the
                            1st reference ("scm") or in the 2nd refernce ("gb"). If not not supplied, the
                            option is used coming with the 'VCA' object.}
}
\value{
(matrix) corresponding to variance-covariance matrix of variance components
}
\description{
This function computes the variance-covariance matrix of variance components (VC) either
applying the approach given in the \eqn{1^{st}}{1st} reference ('method="scm"') or using
the approximation given in the \eqn{2^{nd}}{2nd} reference ('method="gb"').
}
\details{
When 'method="scm"' is used function \code{\link{getVCvar}} is called implementing this rather
time-consuming algorithm. Both approaches, respectively the results they generate, diverge for
increasing degree of unbalancedness. For balanced designs, they seem to differ only due to
numerical reasons (error propagation).

This function is called on a 'VCA' object, which can be the sole argument. In this case the value
assigned to element 'VarVC.method' of the 'VCA' object will be used
(see \code{\link{getVCvar}} for computational details).
}
\examples{
\dontrun{
data(realData)
dat1 <- realData[realData$PID==1,]
fit  <- anovaVCA(y~lot/calibration/day/run, dat1, SSQ.method="qf")
vcovVC(fit)
vcovVC(fit, "scm")		# Searle-Casella-McCulloch method (1st reference)
vcovVC(fit, "gb")		# Giesbrecht and Burns method (2nd reference)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
\references{
Searle, S.R, Casella, G., McCulloch, C.E. (1992), Variance Components, Wiley New York

Giesbrecht, F.G. and Burns, J.C. (1985), Two-Stage Analysis Based on a Mixed Model: Large-Sample
Asymptotic Theory and Small-Sample Simulation Results, Biometrics 41, p. 477-486
}

