% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbtCvrt.R
\name{vbt2arr}
\alias{vbt2arr}
\title{Convert a vector binary tree to array}
\usage{
vbt2arr(x)
}
\arguments{
\item{x}{A vector binary tree to be converted.}
}
\value{
Return an array filled with the binding character elements.
}
\description{
Convert a vector binary tree to an array. The pure numeric layers will be sorted intrinsically then all
elements will be bound in certain order as one character element, and filled into the proper location in the array.
}
\examples{
#Make column names of datatest into vector binary tree:
vbt <- dl2vbt(chrvec2dl(colnames(datatest), "-"))

#Convert the vector binary tree to an array:
vbt2arr(vbt)
}
\seealso{
\code{\link[VBTree:vbt2dl]{vbt2dl}}, \code{\link[VBTree:vbt2ts]{vbt2ts}}.
}
\keyword{Vector.Binary.Tree}
\keyword{array}
