#' UniprotR: A package for retrieving proteins information from UniProt.
#'
#' UniprotR provides different functions to retrieve proteins information provided by the UniProt.
#' UniprotR could be divided into two categories one for retrieving and one for visualizing the data.
#'
#' @section The first category for retrieving data:
#' ____________________________________________
#'
#' GetCross_references_Information
#'
#' GetExpression_uniprot
#'
#' GetFamily_Domains_uniprot
#'
#' GetGeneral_Information
#'
#' GetMiscellaneous_uniprot
#'
#' GetNamesTaxa
#'
#' GetPathology_Biotech_uniprot
#'
#' GetProteinFunction
#'
#' GetProteinGOInfo
#'
#' GetProteinInteractions
#'
#' GetProteoAnnotator
#'
#' GetPTM_Processsing_uniprot
#'
#' GetPublication
#'
#' GetSequences_uniprot
#'
#' GetStructureInfo
#'
#' GetSubcellular_location
#'
#' GetTaxaidentifier
#'
#' GetTaxonomic_lineage_uniprot
#'
#'
#' each function has a description that could be reached by >>> ?Function_Name
#'
#' @section The second category for visualizing data:
#' _______________________________________________
#'
#' PlotProteinsLoc
#'
#' PlotProteinTaxa
#'
#'
#' each function has a description that could be reached by  >>> ?Function_Name
#'
#' @author Mohmed Soudy and Ali Mostafa
#'
#' @docType package
#' @name UniprotR
NULL
