% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC.wrap.R
\name{IBIS.logreg.opts}
\alias{IBIS.logreg.opts}
\title{Additional argument generator for \code{\link[=IBIS.logreg]{IBIS.logreg()}}}
\usage{
IBIS.logreg.opts(
  N = 1000,
  ess = N/2,
  n_move = 1,
  weighted = FALSE,
  prior.override = FALSE,
  rprior = NULL,
  dprior = NULL,
  ...
)
}
\arguments{
\item{N}{Number of particles for the SMC sampler. Defaults to 1000.}

\item{ess}{Effective Sample Size Threshold: If the effective sample size of
the particles falls below this value then a resample move step is
triggered. Defaults to \code{N/2}.}

\item{n_move}{Number of Metropolis-Hastings steps to apply each time a
resample move step is triggered. Defaults to 1.}

\item{weighted}{Should the outputted samples be weighted? Defaults to
\code{FALSE}.}

\item{prior.override}{Are you overriding the default multivariate normal
form of the prior? Defaults to \code{FALSE}.}

\item{rprior}{Function which produces samples from your prior if the default
prior form is to be overridden. If using the default prior form this does
not need to be specified.}

\item{dprior}{Function which produces your specified priors density for
inputted samples if the default prior form is to be overridden. If using the
default prior form this does not need to be specified.}

\item{...}{Additional arguments required for complete specification of the
two prior functions given, if the default prior form is to be overridden.}
}
\value{
A list consisting of:

\describe{
\item{\code{N}}{Number of particles for the SMC sampler}
\item{\code{ess}}{Effective Sample Size Threshold}
\item{\code{n_move}}{Number of Metropolis-Hastings steps}
\item{\code{rprior}}{Function which produces samples from your prior. \code{NULL} if
\code{prior.override==FALSE}.}
\item{\code{dprior}}{Function which produces your specified priors density for
inputted samples. \code{NULL} if \code{prior.override==FALSE}.}
\item{\code{prior.override}}{Logical value indicating if the prior has been
overridden or not.}
\item{\code{weighted}}{Logical value indicating if the outputted particles of
\code{IBIS.logreg} should be weighted or not.}
\item{\code{MoreArgs}}{A list of the additional arguments required for \code{rprior}
and \code{dprior}. \code{NULL} if \code{prior.override==FALSE}.}
}
}
\description{
This function is used to specify additional arguments to
\code{IBIS.logreg}.
}
\details{
This function should only be used to provide additional control
arguments to \code{IBIS.logreg}.

Specifying \code{rprior} and \code{dprior} will not override the default prior form
unless \code{prior.override=TRUE}. If a multivariate normal form is required then
the arguments for this prior should be specified in \code{IBIS.logreg}.
}
\examples{

#Specifying a multivariate independent uniform prior

rmviu <- function(n,a,b){
return(mapply(FUN = function(min.vec,max.vec,pn){stats::runif(pn,a,b)},
              min.vec=a,max.vec=b,MoreArgs = list(pn = n)))
}
dmviu <- function(x,a,b){
for(ii in 1:ncol(x)){
  x[,ii] <- dunif(x[,ii],a[ii],b[ii])
}
return(apply(x,1,prod))
}

IBIS.logreg.opts(prior.override = TRUE,rprior = rmviu,
                 dprior = dmviu,a=rep(0,3),b=rep(1,3))


}
\seealso{
\code{\link[=IBIS.logreg]{IBIS.logreg()}}
}
\keyword{IBIS}
\keyword{control}
\keyword{options}
