% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XenaHub-class.R
\name{samples}
\alias{samples}
\title{Get Samples of a XenaHub object according to 'by' and 'how' action arguments}
\usage{
samples(x, i = character(), by = c("hosts", "cohorts", "datasets"),
  how = c("each", "any", "all"))
}
\arguments{
\item{x}{a \link{XenaHub} object}

\item{i}{a empty character}

\item{by}{a character specify \code{by} action}

\item{how}{a character specify \code{how} action}
}
\value{
a list include samples
}
\description{
One is often interested in identifying samples or features present in each data set,
or shared by all data sets, or present in any of several data sets.
Identifying these samples, including samples in arbitrarily chosen data sets.
}
\examples{
\donttest{
xe = XenaHub(cohorts = "Cancer Cell Line Encyclopedia (CCLE)")
# samples in each dataset, first host
x = samples(xe, by="datasets", how="each")[[1]]
lengths(x)        # data sets in ccle cohort on first (only) host
}
}
