% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnorm.R
\name{tnorm}
\alias{tnorm}
\title{Truncated univariate normal distribution}
\arguments{
\item{n}{number of observations}

\item{p}{vector or matrix of probabilities}

\item{mu}{vector of means}

\item{sd}{vector of standard deviations}

\item{lb}{vector of lower truncation limits}

\item{ub}{vector of upper truncation limits}

\item{method}{string, either of \code{fast} or \code{invtransfo}}
}
\value{
vector or matrix of random variates (\code{rtnorm}) or of quantiles (\code{ptnorm}), depending on the input
}
\description{
The function provides efficient state-of-the-art random number generation of a vector of truncated univariate distribution
of the same length as the lower bound vector. The function is vectorized and the vector of means \code{mu} and 
of standard deviations \code{sd} are recycled.
 
If \code{mu} or \code{sd} are not specified they assume the default values of 0 and 1, respectively.
}
\examples{
rtnorm(n = 10, mu = 2, lb = 1:10, ub = 2:11, method = "fast")
qtnorm(runif(10), mu = 2, lb = 1:10, ub = 2:11, sd = 1)
}
