% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.select_Millar.R
\name{plot.select_Millar}
\alias{plot.select_Millar}
\title{Millar's selectivity plot}
\usage{
\method{plot}{select_Millar}(x, plotlens = NULL, standardise = TRUE,
  deviance_plot = TRUE, ...)
}
\arguments{
\item{x}{a list of the class \code{"select_Millar"} containing the results of
Millar's selectivity model}

\item{plotlens}{A vector with lengths which should be used for drawing the
selection curves}

\item{standardise}{A parameter indicating if the retention should be realtive
to the maximum value (Default: TRUE).}

\item{deviance_plot}{logical; indicating whether a plot of deviance residuals should
be displayed}

\item{...}{additional parameter options from plot function}
}
\description{
This function plots the selectivity estimates of Millar's
   selectivity model (\code{\link{select_Millar}}).
}
\details{
This function draws a selectivity plot for the object class
   \code{"select_Millar"}, which is created by applying Millar's selectivity model
   \code{\link{select_Millar}}.
}
\examples{
data(gillnet)

output <- select_Millar(gillnet, x0 = c(60,4), rel.power = rep(1,8),
   rtype = "norm.loc", plot = FALSE)

plot(output, plotlens = seq(40,90,0.1), deviance_plot = FALSE)

}
\references{
Millar, R. B., Holst, R., 1997. Estimation of gillnet and hook selectivity
 using log-linear models. \emph{ICES Journal of Marine Science: Journal du Conseil},
 54(3), 471-477.
}

